/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.utils;

import cn.ipokerface.common.exception.ServiceException;
import org.springframework.lang.Nullable;

public abstract class AssertUtils {
    public static void isTrue(boolean expression, String name) {
        if (!expression) {
            throw new ServiceException(name + " is not true!");
        }
    }

    public static void isNull(@Nullable Object object, String name) {
        if (object != null) {
            throw new ServiceException(name + " must be null!");
        }
    }

    public static void notNull(@Nullable Object object, String name) {
        if (object == null || "".equals(object)) {
            throw new ServiceException(name + " is required!");
        }
    }

    public static void notNull(@Nullable String string, String name) {
        if (string == null || "".equals(string)) {
            throw new ServiceException(name + " is required!");
        }
    }

    public static void notZero(Number number, String name) {
        AssertUtils.notNull(number, name);
        if (number.intValue() == 0) {
            throw new ServiceException(name + "must not be zero");
        }
    }

    public static void length(String value, String name, int min, int max) {
        if (min >= 0 && max >= 0) {
            if (value != null && value.length() >= min && value.length() <= max) {
                return;
            }
            throw new ServiceException(name + " out of size[" + min + "~" + max + "]");
        }
        if (min >= 0) {
            if (value != null && value.length() >= min) {
                return;
            }
            throw new ServiceException(name + " out of size[~" + max + "]");
        }
        if (max >= 0 && value != null && value.length() > max) {
            throw new ServiceException(name + " out of size[" + min + "~]");
        }
    }

    public static void range(Number value, String name, int min, int max) {
        if (value == null) {
            return;
        }
        int intValue = value.intValue();
        if (min != -1 && intValue < min) {
            throw new ServiceException(name + " out of range[" + min + "~" + max + "]");
        }
        if (max != -1 && intValue > max) {
            throw new ServiceException(name + " out of range[" + min + "~" + max + "]");
        }
    }
}

