/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    private int code;
    private String message;
    private Long timestamp;
    private Map<String, Object> body;
    public static final int code_success = 10000;
    public static final int code_error = 10001;
    public static final String success = "success";
    public static final String error = "error";

    private Response() {
    }

    private Response(int code, String message, long timestamp, Map<String, Object> body) {
        this.code = code;
        this.body = body;
        this.message = message;
        this.timestamp = timestamp;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private int code = 10000;
        private String message = "success";
        private Map<String, Object> data = new HashMap<String, Object>();

        public Builder push(String key, Object data) {
            this.data.put(key, data);
            return this;
        }

        public Builder pop(String key) {
            this.data.remove(key);
            return this;
        }

        public Builder object(Object obj) {
            if (obj != null) {
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)obj));
                for (String key : jsonObject.keySet()) {
                    Object value = jsonObject.get((Object)key);
                    if (value == null || "".equals(value)) continue;
                    this.data.put(key, value);
                }
            }
            return this;
        }

        public Builder object(Map<String, Object> obj) {
            if (!CollectionUtils.isEmpty(obj)) {
                for (Map.Entry<String, Object> entry : obj.entrySet()) {
                    if (entry.getValue() == null || "".equals(entry.getValue())) continue;
                    this.data.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public Builder error() {
            return this.error(Response.error);
        }

        public Builder error(int code) {
            return this.error(code, Response.error);
        }

        public Builder error(String message) {
            return this.error(10001, message);
        }

        public Builder error(int code, String message) {
            this.code = code;
            this.message = message;
            this.data.clear();
            return this;
        }

        public Response build() {
            return new Response(this.code, this.message, System.currentTimeMillis(), this.data);
        }
    }
}

