/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.collection;

import cn.ipokerface.common.collection.LinkedNode;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<K>
implements Serializable {
    private static final long serialVersionUID = -8276923460661712738L;
    private LinkedNode<K> _head;
    private LinkedNode<K> _tail;
    private LinkedNode<K> _current;
    private int length = 0;

    public synchronized int size() {
        return this.length;
    }

    public synchronized boolean hasNode() {
        return this.length > 0;
    }

    public synchronized boolean hasMore() {
        return this._current != null;
    }

    public synchronized void put(LinkedNode<K> node) {
        if (this.length == 0) {
            this._head = node;
            this._current = node;
        } else if (this.length == 1) {
            this._head.next = node;
            node.previous = this._head;
        } else {
            this._tail.next = node;
            node.previous = this._tail;
        }
        this._tail = node;
        node.setContainer(this);
        ++this.length;
    }

    public synchronized LinkedNode<K> take() {
        if (this.length == 0 || this._current == null) {
            return null;
        }
        LinkedNode<K> node = this._current;
        this._current = this._current.next;
        return node;
    }

    public synchronized LinkedNode<K> get() {
        return this._current;
    }

    public synchronized void seekToHead() {
        this._current = this._head;
    }

    public synchronized boolean remove(LinkedNode<K> node) {
        if (node == null || this.length == 0) {
            return false;
        }
        if (node.previous == null && node.next == null) {
            this._current = null;
            this._head = null;
            this._tail = null;
        } else if (node.previous == null) {
            node.next.previous = null;
            this._head = node.next;
            if (this._current.equals(node)) {
                this._current = node.next;
            }
        } else if (node.next == null) {
            node.previous.next = null;
            this._tail = node.previous;
            if (this._current.equals(node)) {
                this._current = node.previous;
            }
        } else {
            node.previous.next = node.next;
            node.next.previous = node.previous;
            if (this._current.equals(node)) {
                this._current = node.next;
            }
        }
        node.previous = null;
        node.next = null;
        --this.length;
        return true;
    }

    public synchronized LinkedNode<K> removeFirst() {
        LinkedNode<K> result = this._head;
        if (this.remove(this._head)) {
            return result;
        }
        return null;
    }

    public synchronized LinkedNode<K> removeLast() {
        LinkedNode<K> result = this._tail;
        if (this.remove(this._tail)) {
            return result;
        }
        return null;
    }

    public synchronized void clear() {
        this._head = null;
        this._tail = null;
        this._current = null;
        this.length = 0;
    }

    public synchronized boolean contains(LinkedNode<K> node) {
        if (node == null) {
            return false;
        }
        if (this.length == 0 || this._head == null) {
            return false;
        }
        if (node.equals(this._head)) {
            return true;
        }
        LinkedNode<K> compareNode = this._head;
        for (int i = 1; i < this.length && (compareNode = this._head.next) != null; ++i) {
            if (!node.equals(compareNode)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean contains(K ele) {
        if (this.length == 0 || this._head == null) {
            return false;
        }
        if (ele == null && this._head.object() == null || ele.equals(this._head.object())) {
            return true;
        }
        LinkedNode<K> compareNode = this._head;
        for (int i = 1; i < this.length && (compareNode = this._head.next) != null; ++i) {
            if ((ele != null || compareNode.object() != null) && !ele.equals(compareNode.object())) continue;
            return true;
        }
        return false;
    }
}

