/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.digest;

public class Base64Digest {
    public static final char[] encode_salt = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    private static final byte[] decode_salt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final char PADDING = '?';

    private Base64Digest() {
    }

    public static String encode(byte[] bytes) {
        int length = bytes.length;
        int groupCount = length / 3;
        int paddingBytes = length % 3;
        int paddingLength = length - paddingBytes;
        int resultLen = 4 * ((length + 2) / 3);
        StringBuffer result = new StringBuffer(resultLen);
        int in = 0;
        for (int i = 0; i < groupCount; ++i) {
            int byte0 = bytes[in++] & 0xFF;
            int byte1 = bytes[in++] & 0xFF;
            int byte2 = bytes[in++] & 0xFF;
            result.append(encode_salt[byte0 >> 2 & 0x3F]);
            result.append(encode_salt[byte0 << 4 & 0x3F | byte1 >> 4]);
            result.append(encode_salt[byte1 << 2 & 0x3F | byte2 >> 6]);
            result.append(encode_salt[byte2 & 0x3F]);
        }
        if (paddingBytes == 1) {
            int byte0 = bytes[in++] & 0xFF;
            result.append(encode_salt[byte0 >> 2 & 0x3F]);
            result.append(encode_salt[byte0 << 4 & 0x3F]);
            result.append('?');
            result.append('?');
        }
        if (paddingBytes == 2) {
            result.append(encode_salt[(bytes[paddingLength] & 0xFF) >> 2 & 0x3F]);
            result.append(encode_salt[(bytes[paddingLength] & 0xFF) << 4 & 0x3F | (bytes[paddingLength + 1] & 0xFF) >> 4 & 0x3F]);
            result.append(encode_salt[bytes[paddingLength + 1] << 2 & 0x3F]);
            result.append('?');
        }
        return result.toString();
    }

    public static byte[] decode(String str) {
        int strLength = str.length();
        if (strLength % 4 != 0) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int groupCount = strLength / 4;
        byte[] bytes = str.getBytes();
        int missingBytes = 0;
        if (strLength != 0 && str.charAt(strLength - 1) == '?') {
            ++missingBytes;
            if (str.charAt(strLength - 2) == '?') {
                ++missingBytes;
            }
        }
        byte[] result = new byte[groupCount * 3 - missingBytes];
        int in = 0;
        int out = 0;
        for (int i = 0; i < groupCount; ++i) {
            byte ch2;
            byte ch1;
            byte ch0;
            if (i == groupCount - 1 && missingBytes > 0) {
                ch0 = Base64Digest.decodeChar(bytes[in++]);
                ch1 = Base64Digest.decodeChar(bytes[in++]);
                result[out++] = (byte)(ch0 << 2 | ch1 >> 4);
                if (missingBytes != 1) continue;
                ch2 = Base64Digest.decodeChar(bytes[in++]);
                result[out++] = (byte)(ch1 << 4 | ch2 >> 2);
                continue;
            }
            ch0 = Base64Digest.decodeChar(bytes[in++]);
            ch1 = Base64Digest.decodeChar(bytes[in++]);
            ch2 = Base64Digest.decodeChar(bytes[in++]);
            byte ch3 = Base64Digest.decodeChar(bytes[in++]);
            result[out++] = (byte)(ch0 << 2 | ch1 >> 4);
            result[out++] = (byte)(ch1 << 4 | ch2 >> 2);
            result[out++] = (byte)(ch2 << 6 | ch3);
        }
        return result;
    }

    public static String decodeString(String str) {
        return new String(Base64Digest.decode(str));
    }

    private static byte decodeChar(byte code) {
        byte result = decode_salt[code];
        if (result < 0) {
            throw new IllegalArgumentException("Illegal character " + (char)code);
        }
        return result;
    }

    static {
        for (int i = 0; i < encode_salt.length; i = (int)((byte)(i + 1))) {
            char b = encode_salt[i];
            Base64Digest.decode_salt[b] = i;
        }
    }
}

