/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.validation;

import cn.ipokerface.common.validation.ValidationResult;
import cn.ipokerface.common.validation.validator.Constraint;
import cn.ipokerface.common.validation.validator.ConstraintValidator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public abstract class Validator {
    public static Set<ValidationResult> validate(Object model) {
        return Validator.validate(model, true);
    }

    public static Set<ValidationResult> validate(Object model, boolean recursion) {
        return Validator.validate(model, null, recursion);
    }

    public static Set<ValidationResult> validate(Object model, Class<?> group) {
        return Validator.validate(model, group, true);
    }

    public static Set<ValidationResult> validate(Object model, Class<?> group, boolean recursion) {
        HashSet<ValidationResult> validationResults = new HashSet<ValidationResult>();
        Class<?> clazz = model.getClass();
        Validator.validate(validationResults, model, group, clazz, recursion);
        return validationResults;
    }

    private static void validate(Set<ValidationResult> validationResults, Object model, Class<?> group, Class<?> clazz, boolean recursion) {
        block16: {
            if (clazz == null) {
                return;
            }
            try {
                Field[] fields = clazz.getDeclaredFields();
                if (fields == null || fields.length <= 0) break block16;
                for (Field field : fields) {
                    int modifier = field.getModifiers();
                    if (Modifier.isStatic(modifier) || Modifier.isFinal(modifier)) continue;
                    field.setAccessible(true);
                    Object value = field.get(model);
                    Annotation[] annotations = field.getDeclaredAnnotations();
                    if (annotations == null || annotations.length <= 0) continue;
                    for (Annotation annotation : annotations) {
                        Class<ConstraintValidator<?, ?>> constraintValidator;
                        Constraint constraintAnnotation;
                        Class<? extends Annotation> annotationType = annotation.annotationType();
                        if (group != null) {
                            try {
                                Method method = annotationType.getMethod("groups", new Class[0]);
                                Object[] groupList = (Class[])method.invoke((Object)annotation, new Object[0]);
                                if (!ArrayUtils.contains((Object[])groupList, group)) {
                                    continue;
                                }
                            }
                            catch (NoSuchMethodException method) {
                            }
                            catch (InvocationTargetException method) {
                                // empty catch block
                            }
                        }
                        if ((constraintAnnotation = annotationType.getAnnotation(Constraint.class)) == null || (constraintValidator = constraintAnnotation.validator()) == null || !ConstraintValidator.class.isAssignableFrom(constraintValidator)) continue;
                        ParameterizedType parentConstraint = (ParameterizedType)constraintValidator.getGenericInterfaces()[0];
                        Class requiredObjectType = (Class)parentConstraint.getActualTypeArguments()[1];
                        if (!requiredObjectType.isAssignableFrom(value.getClass())) {
                            throw new IllegalArgumentException("Wrong parameter type on annotation:" + annotation.annotationType().getName() + "   Required: " + requiredObjectType.getName());
                        }
                        ConstraintValidator<?, ?> validator = constraintValidator.newInstance();
                        boolean result = validator.validate(value, annotation);
                        if (result) continue;
                        try {
                            Method method = annotationType.getMethod("message", new Class[0]);
                            String message = method.invoke((Object)annotation, new Object[0]).toString();
                            validationResults.add(new ValidationResult(field.getName(), message));
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
        }
        if (recursion) {
            Validator.validate(validationResults, model, group, clazz.getSuperclass(), true);
        }
    }
}

