package cn.ipokerface.common.validation.validator;

import java.lang.annotation.Annotation;

/**
 * Created by       PokerFace
 * Create Date      2019-11-25.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:     Abstract constraint's validator of all kinds of validators.
 *                  Defines the logic to validate a given constraint {@code A}
 *                  for a given object type {@code T}.
 *                  <p>
 *                  Implementations must comply to the following restriction:
 *                  <ul>
 *                      <li>{@code T} must resolve to a non parameterized type</li>
 *                      <li>or generic parameters of {@code T} must be unbounded
 *                      wildcard types</li>
 *                  </ul>
 *                  <p>
 *                  The annotation  can be put on a
 *                  {@code ConstraintValidator} implementation to mark it as supporting
 *                  cross-parameter constraints. Check out
 *                  and Constraint for more information.
 *
 */


public interface ConstraintValidator<A extends Annotation, T> {


    /**
     *  main method that invoke by Validator
     *  in {@link cn.ipokerface.common.validation.ValidatorContext} to validate parameter
     *  under the <code>A</code> annotation.
     *
     * @param value parameter value
     * @param constraintAnnotation parameter annotation
     * @return if it is complete by this validator.
     */
    public boolean validate(T value, A constraintAnnotation);


}
