package cn.ipokerface.common.validation.validator;


import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by       PokerFace
 * Create Date      2019-11-25.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class PatternConstraintValidator implements ConstraintValidator<cn.ipokerface.common.validation.constraint.Pattern, String> {

    /**
     *  Validate  string by some pattern
     *  <code>Pattern.compile()</code>
     *  <code>pattern.match()</code>
     *
     * @param value parameter value
     * @param constraintAnnotation parameter annotation
     * @return
     */
    public boolean validate(String value, cn.ipokerface.common.validation.constraint.Pattern constraintAnnotation) {
        if (value == null || "".equals(value)) return true;
        String patternValue =  constraintAnnotation.value();
        if (patternValue == null || "".equals(patternValue)) return true;

        Pattern pattern = java.util.regex.Pattern.compile(patternValue);
        Matcher matcher = pattern.matcher(value);

        if (matcher.matches()) return true;

        return false;
    }
}
