package cn.ipokerface.common.validation.constraint;

import cn.ipokerface.common.validation.validator.Constraint;
import cn.ipokerface.common.validation.validator.NotNullConstraintValidator;

import java.lang.annotation.*;

/**
 * Created by       PokerFace
 * Create Date      2019-11-25.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:     This constraint requires value not null <code>object != null</code>
 */

@Target({ ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validator = NotNullConstraintValidator.class)
public @interface NotNull{

    String message() default "Can not be null!";

    Class<?>[] groups() default { };

}
