package cn.ipokerface.common.validation;

import cn.ipokerface.common.validation.validator.Constraint;
import cn.ipokerface.common.validation.validator.ConstraintValidator;
import org.apache.commons.lang3.ArrayUtils;

import java.lang.annotation.Annotation;
import java.lang.reflect.*;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by       PokerFace
 * Create Date      2019-11-25.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public abstract class Validator {


    /**
     *  Validate an object witch is annotated by some constraint like
     *  {@link cn.ipokerface.common.validation.constraint.NotNull}
     * {@link cn.ipokerface.common.validation.constraint.Min} and so on.
     * if all property is validated by constrain
     * return <code>null</code> in set.
     * if not, return <code>set of ValidationResult</code>
     *
     * see {@link #validate(Object, boolean)}
     *
     * @param model object to validate
     * @return validate result of this object
     */
    public static Set<ValidationResult> validate(Object model){
        return validate(model, true);
    }


    /**
     *  Validate an object witch is annotated by some constraint like
     *  {@link cn.ipokerface.common.validation.constraint.NotNull}
     * {@link cn.ipokerface.common.validation.constraint.Min} and so on.
     * if all property is validated by constrain
     * return <code>null</code> in set.
     * if not, return <code>set of ValidationResult</code>
     *
     * @param model object to validate
     * @param recursion if recursion validate supper model of model or not
     * @return validate result of this object
     */
    public static Set<ValidationResult> validate(Object model,boolean recursion){
        return validate(model, null, recursion);
    }


    /**
     *  Validate an object witch is annotated by some constraint like
     *  {@link cn.ipokerface.common.validation.constraint.NotNull}
     * {@link cn.ipokerface.common.validation.constraint.Min} and so on.
     * if all property is validated by constrain
     * return <code>null</code> in set.
     * if not, return <code>set of ValidationResult</code>
     *
     * @param model object to validate
     * @param group validate group of model
     * @return validate result of this object
     */
    public static Set<ValidationResult> validate(Object model,Class<?> group){
        return validate(model, group, true);
    }



    /**
     *  Validate an object witch is annotated by some constraint like
     *  {@link cn.ipokerface.common.validation.constraint.NotNull}
     * {@link cn.ipokerface.common.validation.constraint.Min} and so on.
     * if all property is validated by constrain
     * return <code>null</code> in set.
     * if not, return <code>set of ValidationResult</code>
     *
     * @param model object to validate
     * @param group validate group of model
     * @param recursion if recursion validate supper model of model or not
     * @return validate result of this object
     */
    public static Set<ValidationResult> validate(Object model,Class<?> group,boolean recursion){
        Set<ValidationResult> validationResults = new HashSet<ValidationResult>();

        Class<?> clazz = model.getClass();

        validate(validationResults, model,group, clazz, recursion);

        return validationResults;
    }





    private static void validate(Set<ValidationResult> validationResults,Object model,Class<?> group, Class<?> clazz, boolean recursion){
        if (clazz == null) return;
        try{

            Field[] fields = clazz.getDeclaredFields();

            if (fields != null && fields.length > 0){
                outer: for(Field field: fields){
                    int modifier = field.getModifiers();
                    if (Modifier.isStatic(modifier) || Modifier.isFinal(modifier)) continue outer;

                    field.setAccessible(true);
                    Object value = field.get(model);
                    Annotation[] annotations = field.getDeclaredAnnotations();
                    if (annotations != null && annotations.length > 0){
                        inner: for(Annotation annotation: annotations){

                            Class<?> annotationType = annotation.annotationType();

                            if (group != null) {
                                try{
                                    Method method = annotationType.getMethod("groups");
                                    Class<?>[] groupList = (Class<?>[])method.invoke(annotation);
                                    if (!ArrayUtils.contains(groupList, group)) continue inner;
                                }catch (NoSuchMethodException e){

                                }catch (InvocationTargetException e1){

                                }
                            }
                            Annotation constraintAnnotation = annotationType.getAnnotation(Constraint.class);
                            if (constraintAnnotation == null) continue inner;
                            Class<?> constraintValidator = ((Constraint) constraintAnnotation).validator();
                            if (constraintValidator == null || !ConstraintValidator.class.isAssignableFrom(constraintValidator))
                                continue inner;
                            ParameterizedType parentConstraint = (ParameterizedType)(constraintValidator.getGenericInterfaces()[0]);
                            // Get the second parameterized Type.
                            Class<?> requiredObjectType= (Class<?>)parentConstraint.getActualTypeArguments()[1];
                            if (!requiredObjectType.isAssignableFrom(value.getClass()))
                                throw new IllegalArgumentException("Wrong parameter type on annotation:" + annotation.annotationType().getName()
                                        + "   Required: "+requiredObjectType.getName());
                            ConstraintValidator validator = (ConstraintValidator) constraintValidator.newInstance();

                            boolean result = validator.validate(value, annotation);

                            if (!result) {
                                try{
                                    Method method = annotationType.getMethod("message");
                                    String message = method.invoke(annotation).toString();
                                    validationResults.add(new ValidationResult(field.getName(), message));
                                }catch (NoSuchMethodException e){
                                    e.printStackTrace();
                                }catch (InvocationTargetException e1){
                                    e1.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
        }catch (IllegalAccessException e){
            e.printStackTrace();
        }catch (InstantiationException e1){
            e1.printStackTrace();
        }

        if (recursion) validate(validationResults, model,group, clazz.getSuperclass(), true);
    }

}
