package cn.ipokerface.common.validation.validator;

import cn.ipokerface.common.validation.constraint.Size;

import java.util.Collection;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2019-11-25.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class SizeConstraintValidator implements ConstraintValidator<Size, Object> {

    /**
     *  Only if value instance of {@link Collection} or {@link Map} or {@link String}
     *  can by validated by this constraint. use
     *  <code>Collection.size()</code>
     *  <code>Map.size()</code>
     *  <code>String.length()</code>
     *
     * @param value parameter value
     * @param constraintAnnotation parameter annotation
     * @return if validated or not
     */
    public boolean validate(Object value, Size constraintAnnotation) {
        int size = 0;
        if (value == null){

        }
        else if (value instanceof Collection){
            size =  ((Collection) value).size();
        }
        else if (value instanceof Map){
            size = ((Map) value).size();
        }
        else if (value instanceof String) {
            size = ((String) value).length();
        }

        if (constraintAnnotation.min() != -1 && size < constraintAnnotation.min()){
            return false;
        }
        else if (constraintAnnotation.max() != -1 && size > constraintAnnotation.max()){
            return false;
        }

        return true;
    }
}
