package cn.ipokerface.common.validation.validator;

import cn.ipokerface.common.validation.constraint.NotEmpty;

import java.util.Collection;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2019-11-25.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class NotEmptyConstraintValidator implements ConstraintValidator<NotEmpty, Object> {


    public boolean validate(Object value, NotEmpty constraintAnnotation) {

        if (value == null){
            return false;
        }
        else if (value instanceof Collection){
            return ((Collection) value).size() > 0;
        }
        else if (value instanceof Map){
            return ((Map) value).size() > 0;
        }
        else if (value instanceof String) {
            return ((String) value).length() > 0;
        }

        return true;
    }
}
