package cn.ipokerface.common.validation.constraint;

import cn.ipokerface.common.validation.validator.Constraint;
import cn.ipokerface.common.validation.validator.SizeConstraintValidator;

import java.lang.annotation.*;

/**
 * Created by       PokerFace
 * Create Date      2019-11-25.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:     annotation on
 *                  <code>{@link java.util.Collection}</code>
 *                  <code>{@link java.util.Map}</code>
 *                  <code>{@link java.lang.String}</code>
 */


@Target({ ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validator = SizeConstraintValidator.class)
public @interface Size {

    String message() default "";

    Class<?>[] groups() default { };

    long min() default -1;

    long max() default -1;
}
