/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.configuration.web;

import cn.ipokerface.admin.AdminCacheService;
import cn.ipokerface.admin.configuration.api.ControllerExceptionHandler;
import cn.ipokerface.admin.configuration.web.InterceptorProperties;
import cn.ipokerface.admin.configuration.web.MessageProperties;
import cn.ipokerface.admin.model.AccessModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.interceptor.AbstractInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
public class AccessInterceptor
extends AbstractInterceptor {
    private static Logger logger = LoggerFactory.getLogger(AccessInterceptor.class);
    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private ControllerExceptionHandler controllerExceptionHandler;
    @Autowired
    private MessageProperties messageProperties;
    @Autowired
    private InterceptorProperties interceptorProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        String token = request.getHeader("Access-Token");
        if (StringUtils.isEmpty((Object)token)) {
            this.responseJson(response, ResultBody.builder().error(30000, this.messageProperties.getAccessException()).build());
            return false;
        }
        AccessModel accessModel = this.adminCacheService.getAccess(token);
        if (accessModel == null) {
            this.responseJson(response, ResultBody.builder().error(30000, this.messageProperties.getAccessException()).build());
            return false;
        }
        if ("OCCUPIED".equals(accessModel.getAccessToken())) {
            this.responseJson(response, ResultBody.builder().error(30001, this.messageProperties.getAccessInvalid()).build());
            return false;
        }
        long expiredTimestamp = this.interceptorProperties.getAccessExpiredTimestamp();
        if (System.currentTimeMillis() - accessModel.getAccessTimestamp() >= expiredTimestamp) {
            this.responseJson(response, ResultBody.builder().error(30002, this.messageProperties.getAccessExpired()).build());
            return false;
        }
        accessModel.setAccessTimestamp(Long.valueOf(System.currentTimeMillis()));
        accessModel.setExpiredTimestamp(Long.valueOf(accessModel.getAccessTimestamp() + expiredTimestamp));
        this.adminCacheService.setAccess(accessModel);
        return true;
    }
}

