/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.configuration.api;

import cn.ipokerface.admin.configuration.web.MessageProperties;
import cn.ipokerface.admin.exception.AccountExistException;
import cn.ipokerface.admin.exception.PasswordRequireException;
import cn.ipokerface.admin.exception.PasswordWrongException;
import cn.ipokerface.common.exception.ServiceException;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@Order(value=0x7FFFFFFD)
@Configuration
@ControllerAdvice
public class ControllerExceptionHandler
extends cn.ipokerface.web.controller.ControllerExceptionHandler {
    @Autowired
    private MessageProperties messageProperties;

    @ResponseBody
    @ExceptionHandler(value={ServiceException.class})
    public ResultBody exceptionHandler(ServiceException ex) {
        ResultBody.Builder builder = ResultBody.builder();
        if (ex instanceof PasswordWrongException) {
            this.error((Exception)ex);
            builder.error(30103, StringUtils.isEmpty((Object)this.messageProperties.getAccountPasswordWrong()) ? "Wrong Password" : this.messageProperties.getAccountPasswordWrong());
        } else if (ex instanceof PasswordRequireException) {
            this.error((Exception)ex);
            builder.error(30104, StringUtils.isEmpty((Object)this.messageProperties.getAccountPasswordRequire()) ? "Password Required" : this.messageProperties.getAccountPasswordRequire());
        } else if (ex instanceof PasswordRequireException) {
            this.error((Exception)ex);
            builder.error(30100, StringUtils.isEmpty((Object)this.messageProperties.getAccountWrong()) ? "Wrong Account" : this.messageProperties.getAccountWrong());
        } else if (ex instanceof AccountExistException) {
            this.error((Exception)ex);
            builder.error(30101, StringUtils.isEmpty((Object)this.messageProperties.getAccountExist()) ? "Account Exist" : this.messageProperties.getAccountExist());
        } else {
            return super.exceptionHandler((Exception)ex);
        }
        return builder.build();
    }
}

