package cn.ipokerface.admin.controller;


import cn.ipokerface.admin.AdminCacheService;
import cn.ipokerface.admin.Constant;
import cn.ipokerface.admin.annontation.RequiredAuthorization;
import cn.ipokerface.admin.entity.AdminRole;
import cn.ipokerface.admin.entity.AdminRoleUpdate;
import cn.ipokerface.admin.enums.AuthorizationCode;
import cn.ipokerface.admin.model.AuthorityModel;
import cn.ipokerface.admin.model.RoleModel;
import cn.ipokerface.admin.param.RoleAddParam;
import cn.ipokerface.admin.param.RoleUpdateParam;
import cn.ipokerface.admin.service.AuthorityService;
import cn.ipokerface.admin.service.RoleService;
import cn.ipokerface.common.model.BaseListModel;
import cn.ipokerface.common.model.BaseListTotalModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.model.query.PaginationSortableSearchQueryModel;
import cn.ipokerface.common.utils.LocalTimeUtils;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.controller.BaseController;
import com.alibaba.fastjson.JSONArray;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2020-05-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@RestController
@RequestMapping("/api/admin/role")
public class RoleController extends BaseController {

    @Autowired
    private AuthorityService authorityService;

    @Autowired
    private RoleService roleService;
    @Autowired
    private AdminCacheService adminCacheService;


    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ROLE)
    @RequestMapping("/page")
    public ResultBody page(
                           PaginationSortableSearchQueryModel param)
    {
        List<AdminRole> roles = roleService.pageRole(param);
        long total = roleService.totalRole(param);
        List<RoleModel> roleModels = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(roles)) {
            roles.stream().forEach(role -> {
                RoleModel roleModel = new RoleModel();
                roleModel.setId(role.getId());
                roleModel.setName(role.getName());
                roleModel.setRemark(role.getRemark());
                roleModel.setCreatedTimestamp(LocalTimeUtils.timestamp(role.getCreatedTime()));
                roleModel.setUpdatedTimestamp(LocalTimeUtils.timestamp(role.getUpdatedTime()));
                roleModels.add(roleModel);
            });
        }

        return ResultBody.builder()
                .data(new BaseListTotalModel<>(roleModels, total))
                .build();
    }


    @RequestMapping("/all")
    public ResultBody all()
    {
        return ResultBody.builder()
                .data(new BaseListModel<>(roleService.all()))
                .build();
    }




    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ROLE_ADD)
    @RequestMapping("/add")
    public ResultBody add(@Validated RoleAddParam param)
    {
        AdminRole adminRole = new AdminRole();
        BeanUtils.copyProperties(param, adminRole);
        roleService.addRole(adminRole);

        return ResultBody.builder()
                .build();
    }



    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ROLE_REMOVE)
    @RequestMapping("/delete")
    public ResultBody delete(@RequestHeader(Constant.HTTP_HEADER_ACCESS_TOKEN)String token,
                        String roleIds)
    {

        if (!StringUtils.isEmpty(roleIds))
        {
            List<Long> ids = JSONArray.parseArray(roleIds, Long.class);

            roleService.remove(ids);
        }

        return ResultBody.builder()
                .build();
    }


    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ROLE_UPDATE)
    @RequestMapping("/update")
    public ResultBody update(@Validated RoleUpdateParam param)
    {
        AdminRoleUpdate update = new AdminRoleUpdate();
        BeanUtils.copyProperties(param, update);
        roleService.updateRole(update);
        return ResultBody.builder()
                .build();
    }


    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ROLE_AUTH)
    @RequestMapping("/auth")
    public ResultBody auth(String authIds,Long roleId)
    {
        List<Long> ids = null;
        if (!StringUtils.isEmpty(authIds))
        {
             ids  = JSONArray.parseArray(authIds, Long.class);
        }
        roleService.auth(ids, roleId);

        return ResultBody.builder()
                .build();
    }


    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ROLE_AUTH)
    @RequestMapping("/authorities")
    public ResultBody role(Long roleId)
    {
        List<AuthorityModel> models = adminCacheService
                .getRoleAuthorities(cn.ipokerface.common.utils.CollectionUtils.asList(roleId));

        return ResultBody.builder()
                .data(new BaseListModel<>(models))
                .build();
    }


}
