package cn.ipokerface.admin.controller;


import cn.ipokerface.admin.model.AuthorityModel;
import cn.ipokerface.admin.model.AuthorityTreeBody;
import cn.ipokerface.admin.service.AuthorityService;
import cn.ipokerface.common.model.BaseListModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.web.controller.BaseController;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2020-05-29.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@RestController
@RequestMapping("/api/admin/authority")
public class AuthorityController extends BaseController {


    @Autowired
    private AuthorityService authorityService;


    @RequestMapping("/tree")
    public ResultBody tree(){

        List<AuthorityTreeBody> tree = buildAuthorityTree(
                authorityService.authorities(true));

        return ResultBody.builder()
                .data(new BaseListModel<>(tree))
                .build();
    }


    public List<AuthorityTreeBody> buildAuthorityTree(List<AuthorityModel> authorities)
    {
        List<AuthorityTreeBody> models = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(authorities)){
            Map<Long, AuthorityTreeBody> parentMap = new HashMap<>(authorities.size());
             // 第一遍 把所有model放到Map中
            for(AuthorityModel authority: authorities) {
                AuthorityTreeBody model = new AuthorityTreeBody();
                BeanUtils.copyProperties(authority, model);
                parentMap.put(model.getId(), model);
                if (model.getParent() == null || model.getParent().equals(0L)) models.add(model);
            }

            // 第二遍  根据map 构建父子关系
            for(AuthorityTreeBody authority: parentMap.values()){
                if (authority.getParent() != null && !authority.getParent().equals(0L)) {
                    AuthorityTreeBody parent = parentMap.get(authority.getParent());
                    if (parent != null){
                        parent.addChildren(authority);
                    }
                }
            }
        }
        return models;
    }



}
