package cn.ipokerface.admin.controller;


import cn.ipokerface.admin.annontation.RequiredAuthorization;
import cn.ipokerface.admin.entity.AdminAccount;
import cn.ipokerface.admin.entity.AdminAccountUpdate;
import cn.ipokerface.admin.entity.AdminRole;
import cn.ipokerface.admin.enums.AccountStatus;
import cn.ipokerface.admin.enums.AuthorizationCode;
import cn.ipokerface.admin.param.AccountAddParam;
import cn.ipokerface.admin.param.AccountUpdateParam;
import cn.ipokerface.admin.service.AccountService;
import cn.ipokerface.admin.service.RoleService;
import cn.ipokerface.common.model.BaseListModel;
import cn.ipokerface.common.model.BaseListTotalModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.model.query.PaginationSortableSearchQueryModel;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.controller.BaseController;
import com.alibaba.fastjson.JSONArray;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-26.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@RestController
@RequestMapping("/api/admin/account")
public class AccountController extends BaseController {


    @Autowired
    private AccountService accountService;
    @Autowired
    private RoleService roleService;


    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ACCOUNT)
    @RequestMapping("/page")
    public ResultBody page( PaginationSortableSearchQueryModel param)
    {
        return ResultBody.builder()
                .data(new BaseListTotalModel<>(accountService.pageAccount(param),
                        accountService.totalAccount(param)))
                .build();
    }



    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ACCOUNT_ADD)
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultBody add(@Validated AccountAddParam account)
    {
        AdminAccount adminAccount = new AdminAccount();
        BeanUtils.copyProperties(account, adminAccount);
        accountService.add(adminAccount);

        return ResultBody.builder()
                .build();
    }


    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ACCOUNT_REMOVE)
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResultBody delete( String ids)
    {

        if (!StringUtils.isEmpty(ids))
        {
            List<Long> idList = JSONArray.parseArray(ids, Long.class);

            accountService.delete(idList);
        }
        return ResultBody.builder()
                .build();
    }


    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ACCOUNT_UPDATE)
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultBody update(@Validated AccountUpdateParam account)
    {

        AdminAccountUpdate update = new AdminAccountUpdate();
        BeanUtils.copyProperties(account, update);

        accountService.update(update);

        return ResultBody.builder()
                .build();
    }




    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ACCOUNT_RESET)
    @RequestMapping(value = "/reset", method = RequestMethod.POST)
    public ResultBody reset( Long accountId,  String password)
    {

        accountService.resetPassword(accountId, password);

        return ResultBody.builder()
                .build();
    }



    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ACCOUNT_FORBIDDEN)
    @RequestMapping(value = "/forbidden", method = RequestMethod.POST)
    public ResultBody frozen(Long accountId)
    {

        accountService.toggleForbidden(accountId, AccountStatus.AccountStatus_Forbidden);

        return ResultBody.builder()
                .build();
    }




    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ACCOUNT_NORMALIZE)
    @RequestMapping(value = "/normalize", method = RequestMethod.POST)
    public ResultBody release( Long accountId)
    {

        accountService.toggleForbidden(accountId, AccountStatus.AccountStatus_Normal);

        return ResultBody.builder()
                .build();
    }



    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ACCOUNT_ROLE)
    @RequestMapping(value = "/roles", method = RequestMethod.POST)
    public ResultBody roles(Long accountId)
    {

        List<AdminRole> roleModels = roleService.accountRoles(accountId);

        return ResultBody.builder()
                .data(new BaseListModel<>(roleModels))
                .build();
    }




    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_ACCOUNT_ROLE)
    @RequestMapping(value = "/role", method = RequestMethod.POST)
    public ResultBody config(Long accountId, String roleIds)
    {
        List<Long> ids = null;
        if (!StringUtils.isEmpty(roleIds)) {
            ids = JSONArray.parseArray(roleIds, Long.class);
        }
        roleService.accountRoleConfig(accountId, ids);

        return ResultBody.builder()
                .build();
    }















}
