package cn.ipokerface.admin.configuration.web;


import cn.ipokerface.admin.AdminCacheService;
import cn.ipokerface.admin.Constant;
import cn.ipokerface.admin.Result;
import cn.ipokerface.admin.annontation.RequiredAuthorization;
import cn.ipokerface.admin.configuration.api.ControllerExceptionHandler;
import cn.ipokerface.admin.model.AccessModel;
import cn.ipokerface.admin.model.AuthorityModel;
import cn.ipokerface.admin.service.AdminService;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.interceptor.AbstractInterceptor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2020-06-01.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@Component
public class AuthorityInterceptor extends AbstractInterceptor {


    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private MessageProperties messageProperties;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {


        // 如果不是controller 资源  则直接返回
        if (!(handler instanceof HandlerMethod)) return true;

        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();


        RequiredAuthorization[] requireAuthorities = method.getAnnotationsByType(RequiredAuthorization.class);
        if (requireAuthorities != null && requireAuthorities.length > 0)
        {
            // 需要验证权限
            Map<String, AuthorityModel> authorities = catchAuthorities(request);
            for(RequiredAuthorization RequiredAuthorization: requireAuthorities)
            {
                String code = RequiredAuthorization.code();
                if (StringUtils.isEmpty(code)) continue;

                AuthorityModel authorityModel = authorities.get(code);

                if (authorityModel == null) {

                    responseJson(response, ResultBody.builder()
                            .error(Result.ResultCode.CODE_ADMIN_AUTHORIZATION,
                                    messageProperties.getAuthorizationException())
                            .build());
                    return false;
                }
            }
        }

        return true;
    }


    private Map<String, AuthorityModel> catchAuthorities(HttpServletRequest request)
    {
        String accessToken = request.getHeader(Constant.HTTP_HEADER_ACCESS_TOKEN);
        AccessModel accessModel = adminCacheService.getAccess(accessToken);
        List<AuthorityModel> authorityModels = adminCacheService.getRoleAuthorities(adminCacheService.getAccountRoles(accessModel.getAccountId()));

        return resolveAuthorities(authorityModels);
    }


    /**
     * 由于存在Redis中的权限中树的形式
     *
     *
     * @param models
     */
    private Map<String, AuthorityModel> resolveAuthorities(List<AuthorityModel> models)
    {
        Map<String, AuthorityModel> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(models))
        {
            for(AuthorityModel authorityModel: models)
            {
                map.put(authorityModel.getCode(), authorityModel);
            }
        }

        return map;

    }


}
