package cn.ipokerface.admin.configuration.web;

import cn.ipokerface.admin.AdminCacheService;
import cn.ipokerface.admin.Constant;
import cn.ipokerface.admin.Result;
import cn.ipokerface.admin.configuration.api.ControllerExceptionHandler;
import cn.ipokerface.admin.model.AccessModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.interceptor.AbstractInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;

/**
 * Created by       PokerFace
 * Create Date      2020-05-25.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@Component
public class AccessInterceptor extends AbstractInterceptor {

    private static Logger logger = LoggerFactory.getLogger(AccessInterceptor.class);


    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private ControllerExceptionHandler controllerExceptionHandler;
    @Autowired
    private MessageProperties messageProperties;
    @Autowired
    private InterceptorProperties interceptorProperties;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        // 是否是需要验证的
        if (!(handler instanceof HandlerMethod)) return true;

        String token = request.getHeader(Constant.HTTP_HEADER_ACCESS_TOKEN);
        if (StringUtils.isEmpty(token)){
            responseJson(response, ResultBody.builder()
                    .error(Result.ResultCode.CODE_ADMIN_ACCESS, messageProperties.getAccessException())
                    .build());
            return false;
        }
        AccessModel accessModel = adminCacheService.getAccess(token);
        if (accessModel == null) {
            responseJson(response, ResultBody.builder()
                    .error(Result.ResultCode.CODE_ADMIN_ACCESS, messageProperties.getAccessException())
                    .build());
            return false;
        }
        if (AdminCacheService.ACCESS_OCCUPIED_TOKEN.equals(accessModel.getAccessToken())) {
            responseJson(response, ResultBody.builder()
                    .error(Result.ResultCode.CODE_ADMIN_ACCESS_INVALID, messageProperties.getAccessInvalid())
                    .build());
            return false;
        }
        long expiredTimestamp = interceptorProperties.getAccessExpiredTimestamp();
        if ((System.currentTimeMillis() - accessModel.getAccessTimestamp()) >= expiredTimestamp) {
            responseJson(response, ResultBody.builder()
                    .error(Result.ResultCode.CODE_ADMIN_ACCESS_EXPIRED, messageProperties.getAccessExpired())
                    .build());
            return false;
        }

        accessModel.setAccessTimestamp(System.currentTimeMillis());
        accessModel.setExpiredTimestamp(accessModel.getAccessTimestamp() + expiredTimestamp);

        // refresh access token
        adminCacheService.setAccess(accessModel);

        return true;
    }

}
