package cn.ipokerface.admin.configuration.initial;

import cn.ipokerface.admin.AdminCacheService;
import cn.ipokerface.admin.configuration.admin.AdminProperties;
import cn.ipokerface.admin.mapper.AdminAuthorityMapper;
import cn.ipokerface.admin.model.AuthorityModel;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2021/4/11.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */


@Configuration
public class AuthorityInitializingBean implements InitializingBean {

    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private AdminAuthorityMapper adminAuthorityMapper;
    @Autowired
    private AdminProperties adminProperties;


    @Override
    public void afterPropertiesSet() throws Exception {
        List<AuthorityModel> authorities = adminAuthorityMapper.selectAll(null);
        adminCacheService.setAuthorities(authorities);
        // 为超级管理员维护权限列表
        List<Long> authorityIds = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(authorities)) {
            authorities.stream().forEach(authority->{
                authorityIds.add(authority.getId());
            });
        }
        List<Long> roleIds = new ArrayList<>(1);
        roleIds.add(adminProperties.getSuperAdminRoleId());

        adminCacheService.setRoleAuthorities(adminProperties.getSuperAdminRoleId(),authorityIds);
        adminCacheService.setAccountRoles(adminProperties.getSuperAdminId(), roleIds);

    }
}
