/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.controller;

import cn.ipokerface.admin.model.AuthorityModel;
import cn.ipokerface.admin.model.AuthorityTreeBody;
import cn.ipokerface.admin.service.AuthorityService;
import cn.ipokerface.common.model.BaseListModel;
import cn.ipokerface.common.model.BaseModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.web.controller.BaseController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/authority"})
public class AuthorityController
extends BaseController {
    @Autowired
    private AuthorityService authorityService;

    @RequestMapping(value={"/tree"})
    public ResultBody tree() {
        List<AuthorityTreeBody> tree = this.buildAuthorityTree(this.authorityService.authorities(true));
        return ResultBody.builder().data((BaseModel)new BaseListModel(tree)).build();
    }

    public List<AuthorityTreeBody> buildAuthorityTree(List<AuthorityModel> authorities) {
        ArrayList<AuthorityTreeBody> models = new ArrayList<AuthorityTreeBody>();
        if (CollectionUtils.isNotEmpty(authorities)) {
            HashMap<Long, AuthorityTreeBody> parentMap = new HashMap<Long, AuthorityTreeBody>(authorities.size());
            for (AuthorityModel authority : authorities) {
                AuthorityTreeBody model = new AuthorityTreeBody();
                BeanUtils.copyProperties((Object)authority, (Object)((Object)model));
                parentMap.put(model.getId(), model);
                if (model.getParent() != null && !model.getParent().equals(0L)) continue;
                models.add(model);
            }
            for (AuthorityModel authority : parentMap.values()) {
                AuthorityTreeBody parent;
                if (authority.getParent() == null || authority.getParent().equals(0L) || (parent = (AuthorityTreeBody)((Object)parentMap.get(authority.getParent()))) == null) continue;
                parent.addChildren((AuthorityTreeBody)authority);
            }
        }
        return models;
    }
}

