/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.controller;

import cn.ipokerface.admin.annontation.RequiredAuthorization;
import cn.ipokerface.admin.entity.AdminAccount;
import cn.ipokerface.admin.entity.AdminAccountUpdate;
import cn.ipokerface.admin.enums.AccountStatus;
import cn.ipokerface.admin.param.AccountAddParam;
import cn.ipokerface.admin.param.AccountUpdateParam;
import cn.ipokerface.admin.service.AccountService;
import cn.ipokerface.admin.service.RoleService;
import cn.ipokerface.common.model.BaseListModel;
import cn.ipokerface.common.model.BaseListTotalModel;
import cn.ipokerface.common.model.BaseModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.model.query.PaginationSortableSearchQueryModel;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.controller.BaseController;
import com.alibaba.fastjson.JSONArray;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/account"})
public class AccountController
extends BaseController {
    @Autowired
    private AccountService accountService;
    @Autowired
    private RoleService roleService;

    @RequiredAuthorization(code="admin_account")
    @RequestMapping(value={"/page"})
    public ResultBody page(PaginationSortableSearchQueryModel param) {
        return ResultBody.builder().data((BaseModel)new BaseListTotalModel(this.accountService.pageAccount(param), this.accountService.totalAccount(param))).build();
    }

    @RequiredAuthorization(code="admin_account_add")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultBody add(@Validated AccountAddParam account) {
        AdminAccount adminAccount = new AdminAccount();
        BeanUtils.copyProperties((Object)((Object)account), (Object)adminAccount);
        this.accountService.add(adminAccount);
        return ResultBody.builder().build();
    }

    @RequiredAuthorization(code="admin_account_remove")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResultBody delete(String ids) {
        if (!StringUtils.isEmpty((Object)ids)) {
            List idList = JSONArray.parseArray((String)ids, Long.class);
            this.accountService.delete(idList);
        }
        return ResultBody.builder().build();
    }

    @RequiredAuthorization(code="admin_account_update")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResultBody update(@Validated AccountUpdateParam account) {
        AdminAccountUpdate update = new AdminAccountUpdate();
        BeanUtils.copyProperties((Object)((Object)account), (Object)update);
        this.accountService.update(update);
        return ResultBody.builder().build();
    }

    @RequiredAuthorization(code="admin_account_reset")
    @RequestMapping(value={"/reset"}, method={RequestMethod.POST})
    public ResultBody reset(Long accountId, String password) {
        this.accountService.resetPassword(accountId, password);
        return ResultBody.builder().build();
    }

    @RequiredAuthorization(code="admin_account_forbidden")
    @RequestMapping(value={"/forbidden"}, method={RequestMethod.POST})
    public ResultBody frozen(Long accountId) {
        this.accountService.toggleForbidden(accountId, AccountStatus.AccountStatus_Forbidden);
        return ResultBody.builder().build();
    }

    @RequiredAuthorization(code="admin_account_normalize")
    @RequestMapping(value={"/normalize"}, method={RequestMethod.POST})
    public ResultBody release(Long accountId) {
        this.accountService.toggleForbidden(accountId, AccountStatus.AccountStatus_Normal);
        return ResultBody.builder().build();
    }

    @RequiredAuthorization(code="admin_account_role")
    @RequestMapping(value={"/roles"}, method={RequestMethod.POST})
    public ResultBody roles(Long accountId) {
        List roleModels = this.roleService.accountRoles(accountId);
        return ResultBody.builder().data((BaseModel)new BaseListModel(roleModels)).build();
    }

    @RequiredAuthorization(code="admin_account_role")
    @RequestMapping(value={"/role"}, method={RequestMethod.POST})
    public ResultBody config(Long accountId, String roleIds) {
        List ids = null;
        if (!StringUtils.isEmpty((Object)roleIds)) {
            ids = JSONArray.parseArray((String)roleIds, Long.class);
        }
        this.roleService.accountRoleConfig(accountId, ids);
        return ResultBody.builder().build();
    }
}

