/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.configuration.web;

import cn.ipokerface.admin.configuration.admin.AdminProperties;
import cn.ipokerface.admin.configuration.web.AccessInterceptor;
import cn.ipokerface.admin.configuration.web.AuthorityInterceptor;
import cn.ipokerface.admin.configuration.web.InterceptorProperties;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@AutoConfigureAfter(value={AccessInterceptor.class, AuthorityInterceptor.class})
@EnableConfigurationProperties(value={InterceptorProperties.class, AdminProperties.class})
public class SpringWebAutoConfiguration
implements WebMvcConfigurer {
    @Autowired
    private AccessInterceptor accessInterceptor;
    @Autowired
    private AuthorityInterceptor authorityInterceptor;
    @Autowired
    private InterceptorProperties interceptorProperties;

    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration interceptorRegistration = registry.addInterceptor((HandlerInterceptor)this.accessInterceptor).addPathPatterns(new String[]{"/api/admin/**"}).excludePathPatterns(new String[]{"/api/admin/login"});
        if (CollectionUtils.isEmpty(this.interceptorProperties.getIncludeAccessPaths())) {
            interceptorRegistration.addPathPatterns(this.interceptorProperties.getIncludeAccessPaths());
        }
        if (CollectionUtils.isEmpty(this.interceptorProperties.getExcludeAccessPaths())) {
            interceptorRegistration.excludePathPatterns(this.interceptorProperties.getExcludeAccessPaths());
        }
        InterceptorRegistration authorityRegistration = registry.addInterceptor((HandlerInterceptor)this.authorityInterceptor).addPathPatterns(new String[]{"/api/admin/**"});
        if (CollectionUtils.isEmpty(this.interceptorProperties.getIncludeAccessPaths())) {
            authorityRegistration.addPathPatterns(this.interceptorProperties.getIncludeAuthorityPaths());
        }
        if (CollectionUtils.isEmpty(this.interceptorProperties.getExcludeAccessPaths())) {
            authorityRegistration.excludePathPatterns(this.interceptorProperties.getExcludeAuthorityPaths());
        }
    }
}

