/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.configuration.web;

import cn.ipokerface.admin.AdminCacheService;
import cn.ipokerface.admin.annontation.RequiredAuthorization;
import cn.ipokerface.admin.configuration.web.MessageProperties;
import cn.ipokerface.admin.model.AccessModel;
import cn.ipokerface.admin.model.AuthorityModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.interceptor.AbstractInterceptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
public class AuthorityInterceptor
extends AbstractInterceptor {
    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private MessageProperties messageProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        RequiredAuthorization[] requireAuthorities = (RequiredAuthorization[])method.getAnnotationsByType(RequiredAuthorization.class);
        if (requireAuthorities != null && requireAuthorities.length > 0) {
            Map<String, AuthorityModel> authorities = this.catchAuthorities(request);
            for (RequiredAuthorization RequiredAuthorization2 : requireAuthorities) {
                AuthorityModel authorityModel;
                String code = RequiredAuthorization2.code();
                if (StringUtils.isEmpty((Object)code) || (authorityModel = authorities.get(code)) != null) continue;
                this.responseJson(response, ResultBody.builder().error(30003, this.messageProperties.getAuthorizationException()).build());
                return false;
            }
        }
        return true;
    }

    private Map<String, AuthorityModel> catchAuthorities(HttpServletRequest request) {
        String accessToken = request.getHeader("Access-Token");
        AccessModel accessModel = this.adminCacheService.getAccess(accessToken);
        List authorityModels = this.adminCacheService.getRoleAuthorities(this.adminCacheService.getAccountRoles(accessModel.getAccountId()));
        return this.resolveAuthorities(authorityModels);
    }

    private Map<String, AuthorityModel> resolveAuthorities(List<AuthorityModel> models) {
        HashMap<String, AuthorityModel> map = new HashMap<String, AuthorityModel>();
        if (CollectionUtils.isNotEmpty(models)) {
            for (AuthorityModel authorityModel : models) {
                map.put(authorityModel.getCode(), authorityModel);
            }
        }
        return map;
    }
}

