package cn.ipokerface.admin.param;

import cn.ipokerface.common.model.BaseModel;
import cn.ipokerface.common.utils.PatternUtils;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

/**
 * Created by       PokerFace
 * Create Date      2021/5/2.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class AccountAddParam extends BaseModel {

    @NotBlank(message = "username is empty")
    @Length(min = 6,max = 20,message = "username length between 6~20")
    private String username;
    @Length(max = 20, message = "name length must under 20")
    private String name;
    @Length(max = 200, message = "remark length must under 200")
    private String remark;
    @NotBlank(message = "password is required")
    private String password;
    @NotBlank(message = "mobile must not empty")
    @Pattern(regexp = PatternUtils.pattern_str_mobile, message = "mobile format incorrect")
    private String mobile;


    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
