package cn.ipokerface.admin.controller;

import cn.ipokerface.admin.ConfigurationCacheService;
import cn.ipokerface.admin.annontation.RequiredAuthorization;
import cn.ipokerface.admin.entity.Configuration;
import cn.ipokerface.admin.enums.AuthorizationCode;
import cn.ipokerface.admin.model.ConfigurationBody;
import cn.ipokerface.admin.model.ConfigurationModel;
import cn.ipokerface.admin.service.ConfigurationService;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.web.controller.BaseController;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2020-07-30.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@RestController
@RequestMapping("/api/admin/config")
public class ConfigurationController extends BaseController {


    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ConfigurationCacheService configurationCacheService;

    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_CONFIG)
    @RequestMapping("/all")
    public ResultBody properties()
    {
        Map<String, ConfigurationModel> propertyModelMap = configurationCacheService.getProperties();

        return ResultBody.builder()
                .data(new ConfigurationBody(propertyModelMap))
                .build();
    }


    /**
     * properties 参数配置的json数据
     *
     * @param properties properties
     * @return ResultBody
     */
    @RequiredAuthorization(code = AuthorizationCode.CODE_ADMIN_CONFIG_UPDATE)
    @RequestMapping(value = "/config", method = RequestMethod.POST)
    public ResultBody propertiesConfig(String properties)
    {
        List<Configuration> systemPropertyList = JSON.parseArray(properties, Configuration.class);

        configurationService.update(systemPropertyList);

        return ResultBody.builder().build();
    }








}

