package cn.ipokerface.admin.controller;


import cn.ipokerface.admin.AdminCacheService;
import cn.ipokerface.admin.Constant;
import cn.ipokerface.admin.configuration.admin.AdminProperties;
import cn.ipokerface.admin.configuration.web.InterceptorProperties;
import cn.ipokerface.admin.entity.AdminAccount;
import cn.ipokerface.admin.exception.PasswordWrongException;
import cn.ipokerface.admin.model.AccessModel;
import cn.ipokerface.admin.model.AccountModel;
import cn.ipokerface.admin.model.AuthorityModel;
import cn.ipokerface.admin.param.LoginParam;
import cn.ipokerface.admin.service.AdminService;
import cn.ipokerface.common.model.BaseListModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.DigestUtils;
import cn.ipokerface.web.controller.BaseController;
import org.apache.tomcat.util.bcel.Const;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-26.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@RestController
@RequestMapping("/api/admin")
public class AdminController extends BaseController {


    @Autowired
    private AdminService adminService;
    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private AdminProperties adminProperties;
    @Autowired
    private InterceptorProperties interceptorProperties;



    @RequestMapping(value = "/login", method = RequestMethod.POST)
    public ResultBody login(@Validated LoginParam param, HttpServletRequest request) {
        String ip = getClientIpAddress(request);

        AdminAccount adminAccount = null;
        if (adminProperties.getSuperAdminUsername().equals(param.getUsername())) {
            // 超级管理员
            if(!param.getPassword().equals(DigestUtils.md5Hex(adminProperties.getSuperAdminPassword())))
            {
                throw new PasswordWrongException();
            }
            adminAccount = new AdminAccount();
            adminAccount.setId(adminProperties.getSuperAdminId());
            adminAccount.setUsername(adminProperties.getSuperAdminUsername());
            adminAccount.setName(adminProperties.getSuperAdminName());

        } else {
            adminAccount = adminService.login(param.getUsername(), param.getPassword(), ip);
        }

        AccountModel accountModel = new AccountModel();
        BeanUtils.copyProperties(adminAccount, accountModel);

        AccessModel accessModel = new AccessModel();
        accessModel.setAccessToken(DigestUtils.md5Hex(adminAccount.getUsername() + System.currentTimeMillis()));
        accessModel.setAccountId(adminAccount.getId());
        accessModel.setAccessTimestamp(System.currentTimeMillis());
        accessModel.setExpiredTimestamp(accessModel.getAccessTimestamp() + interceptorProperties.getAccessExpiredTimestamp());

        adminCacheService.setAccess(accessModel);
        adminCacheService.setAccount(accountModel);

        return ResultBody.builder()
                .data(accessModel)
                .build();
    }



    @RequestMapping(value = "/logout", method = RequestMethod.POST)
    public ResultBody logout(@RequestHeader(Constant.HTTP_HEADER_ACCESS_TOKEN) String token ) {

        adminCacheService.removeAccess(token);

        return ResultBody.builder()
                .build();
    }

    @RequestMapping(value = "/account")
    public ResultBody account(@RequestHeader(Constant.HTTP_HEADER_ACCESS_TOKEN) String token) throws Exception{

        return ResultBody.builder()
                .data(adminCacheService.getAccount(token))
                .build();

    }


    @RequestMapping(value = "/authorities")
    public ResultBody authorities(@RequestHeader(Constant.HTTP_HEADER_ACCESS_TOKEN) String token) throws Exception{
        // 返回列表由前端自己组装
        AccessModel accessModel = adminCacheService.getAccess(token);
        List<AuthorityModel> authorityModelList = adminCacheService.getRoleAuthorities(adminCacheService.getAccountRoles(accessModel.getAccountId()));
        return ResultBody.builder()
                .data(new BaseListModel(authorityModelList))
                .build();
    }


    @RequestMapping(value = "/password", method = RequestMethod.POST)
    public ResultBody password(@RequestHeader(Constant.HTTP_HEADER_ACCESS_TOKEN)String token,
                             String password,String newPassword) throws Exception
    {
        AccessModel accountModel = adminCacheService.getAccess(token);
        adminService.resetPassword(accountModel.getAccountId(),password, newPassword);

        return ResultBody.builder()
                .build();
    }

}
