package cn.ipokerface.admin.configuration.web;

import cn.ipokerface.admin.Result;
import cn.ipokerface.common.utils.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * Created by       mac
 * Create Date      2020/12/12
 * Version          1.0.0
 * Description:
 */

@Component
@ConfigurationProperties(prefix = "spring.admin.message")
public class MessageProperties {

    private String accessException;
    private String accessInvalid;
    private String accessExpired;
    private String authorizationException;
    private String accountWrong;
    private String accountExist;
    private String accountForbidden;
    private String accountPasswordWrong;
    private String accountPasswordRequire;
    private String roleExist;


    public String getAccessException() {
        return StringUtils.isEmpty(accessException)? Result.ResultMessage.MESSAGE_ADMIN_ACCESS : accessException;
    }

    public void setAccessException(String accessException) {
        this.accessException = accessException;
    }

    public String getAccessInvalid() {
        return StringUtils.isEmpty(accessInvalid)?Result.ResultMessage.MESSAGE_ADMIN_ACCESS_INVALID: accessInvalid;
    }

    public void setAccessInvalid(String accessInvalid) {
        this.accessInvalid = accessInvalid;
    }

    public String getAccessExpired() {
        return StringUtils.isEmpty(accessExpired)?Result.ResultMessage.MESSAGE_ADMIN_ACCESS_EXPIRED:accessExpired;
    }

    public void setAccessExpired(String accessExpired) {
        this.accessExpired = accessExpired;
    }

    public String getAuthorizationException() {
        return StringUtils.isEmpty(authorizationException)?Result.ResultMessage.MESSAGE_ADMIN_AUTHORIZATION: authorizationException;
    }

    public void setAuthorizationException(String authorizationException) {
        this.authorizationException = authorizationException;
    }

    public String getAccountWrong() {
        return StringUtils.isEmpty(accountWrong)?Result.ResultMessage.MESSAGE_ADMIN_ACCOUNT_WRONG:accountWrong;
    }

    public void setAccountWrong(String accountWrong) {
        this.accountWrong = accountWrong;
    }

    public String getAccountExist() {
        return StringUtils.isEmpty(accountExist)?Result.ResultMessage.MESSAGE_ADMIN_ACCOUNT_EXIST:accountExist;
    }

    public void setAccountExist(String accountExist) {
        this.accountExist = accountExist;
    }

    public String getAccountForbidden() {
        return StringUtils.isEmpty(accountForbidden)?Result.ResultMessage.MESSAGE_ADMIN_ACCOUNT_FORBIDDEN:accountForbidden;
    }

    public void setAccountForbidden(String accountForbidden) {
        this.accountForbidden = accountForbidden;
    }

    public String getAccountPasswordWrong() {
        return StringUtils.isEmpty(accountPasswordWrong)?Result.ResultMessage.MESSAGE_ADMIN_ACCOUNT_PASSWORD_WRONG:accountPasswordWrong;
    }

    public void setAccountPasswordWrong(String accountPasswordWrong) {
        this.accountPasswordWrong = accountPasswordWrong;
    }

    public String getAccountPasswordRequire() {
        return StringUtils.isEmpty(accountPasswordRequire)?Result.ResultMessage.MESSAGE_ADMIN_ACCOUNT_PASSWORD_REQUIRED:accountPasswordRequire;
    }

    public void setAccountPasswordRequire(String accountPasswordRequire) {
        this.accountPasswordRequire = accountPasswordRequire;
    }

    public String getRoleExist() {
        return StringUtils.isEmpty(roleExist)?Result.ResultMessage.MESSAGE_ADMIN_ROLE_EXIST:roleExist;
    }

    public void setRoleExist(String roleExist) {
        this.roleExist = roleExist;
    }
}
