package cn.ipokerface.admin.configuration.initial;

import cn.ipokerface.admin.ConfigurationCacheService;
import cn.ipokerface.admin.mapper.ConfigurationMapper;
import cn.ipokerface.admin.model.ConfigurationModel;
import cn.ipokerface.common.log.LoggerAdapter;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2021/4/11.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */

@Configuration
public class ConfigurationInitializingBean extends LoggerAdapter implements InitializingBean {

    @Autowired
    private ConfigurationMapper configurationPropertyMapper;
    @Autowired
    private ConfigurationCacheService configurationCacheService;

    @Override
    public void afterPropertiesSet() throws Exception {
        List<ConfigurationModel> properties = configurationPropertyMapper.selectAll();
        configurationCacheService.setProperties(properties);
        logger.info(" 更新了 {} 个系统配置", CollectionUtils.size(properties));
    }
}
