package cn.ipokerface.admin.configuration.api;

import cn.ipokerface.admin.Result;
import cn.ipokerface.admin.configuration.web.MessageProperties;
import cn.ipokerface.admin.exception.AccountExistException;
import cn.ipokerface.admin.exception.PasswordRequireException;
import cn.ipokerface.admin.exception.PasswordWrongException;
import cn.ipokerface.common.exception.ServiceException;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by       mac
 * Create Date      2020/12/12
 * Version          1.0.0
 * Description:
 */



@Order(Integer.MAX_VALUE - 2)
@Configuration
@ControllerAdvice
public class ControllerExceptionHandler extends cn.ipokerface.web.controller.ControllerExceptionHandler {

    @Autowired
    private MessageProperties messageProperties;


    @ResponseBody
    @ExceptionHandler(value = {ServiceException.class})
    public ResultBody exceptionHandler(ServiceException ex) {
        ResultBody.Builder builder = ResultBody.builder();
        if ( ex instanceof PasswordWrongException) {
            error(ex);
            builder.error(Result.ResultCode.CODE_ADMIN_ACCOUNT_PASSWORD_WRONG, StringUtils.isEmpty(messageProperties.getAccountPasswordWrong())?
                    Result.ResultMessage.MESSAGE_ADMIN_ACCOUNT_PASSWORD_WRONG: messageProperties.getAccountPasswordWrong());
        } else if (ex instanceof PasswordRequireException) {
            error(ex);
            builder.error(Result.ResultCode.CODE_ADMIN_ACCOUNT_PASSWORD_REQUIRED, StringUtils.isEmpty(messageProperties.getAccountPasswordRequire())?
                    Result.ResultMessage.MESSAGE_ADMIN_ACCOUNT_PASSWORD_REQUIRED: messageProperties.getAccountPasswordRequire());
        } else if (ex instanceof PasswordRequireException) {
            error(ex);
            builder.error(Result.ResultCode.CODE_ADMIN_ACCOUNT_WRONG, StringUtils.isEmpty(messageProperties.getAccountWrong())?
                    Result.ResultMessage.MESSAGE_ADMIN_ACCOUNT_WRONG: messageProperties.getAccountWrong());
        } else if (ex instanceof AccountExistException){
            error(ex);
            builder.error(Result.ResultCode.CODE_ADMIN_ACCOUNT_EXIST, StringUtils.isEmpty(messageProperties.getAccountExist())?
                    Result.ResultMessage.MESSAGE_ADMIN_ACCOUNT_EXIST : messageProperties.getAccountExist());
        }else {
            // 未处理的交给父类处理
            return super.exceptionHandler(ex);
        }

        return builder.build();
    }
}
