package cn.ipokerface.admin.service;

import cn.ipokerface.admin.entity.AdminRole;
import cn.ipokerface.admin.entity.AdminRoleEntity;
import cn.ipokerface.admin.entity.AdminRoleUpdate;
import cn.ipokerface.common.model.query.PaginationSortableSearchQueryModel;

import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2020-05-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public interface RoleService {


    /**
     *  分页查角色列表
     *
     * @param query     query
     * @return          roleModel
     */
    List<AdminRole> pageRole(PaginationSortableSearchQueryModel query);

    /**
     * 角色总数
     *
     * @param query     query
     * @return      totalCount
     */
    long totalRole(PaginationSortableSearchQueryModel query);


    /**
     *  获取所有的
     *
     * @return rolemodel
     */
    List<AdminRole> all();


    /**
     *
     * @param role  role
     */
    Long addRole(AdminRole role);

    /**
     *  修改角色信息
     *
     * @param role          roleParam
     */
    void updateRole(AdminRoleUpdate role);

    /**
     *  删除角色
     *
     * @param roleIds  roleIds
     */
    void remove(List<Long> roleIds);

    /**
     *  为角色配置权限
     *
     * @param authIds authorityIds
     * @param roleId    roleId
     */
    void auth(List<Long> authIds,Long roleId);

    /**
     * 账号下的角色列表
     *
     * @param accountId accountId
     * @return roleModels
     */
    List<AdminRole> accountRoles(Long accountId);


    /**
     *  为账号配置角色
     *
     * @param accountId accountId
     * @param roleIds   roleIds
     */
    void accountRoleConfig(Long accountId,List<Long> roleIds);

}
