/*
Mysql Database Constructer

Target Server Type    : MYSQL
Target Server Version : 8.0.xx
File Encoding         : UTF-8

Date:
*/

SET FOREIGN_KEY_CHECKS=0;


-- ----------------------------
-- Table structure for ADMIN_ACCOUNT
-- ----------------------------
DROP TABLE IF EXISTS ADMIN_ACCOUNT;
CREATE TABLE ADMIN_ACCOUNT(
      ID                      BIGINT              NOT NULL            COMMENT '主键ID' ,
      USERNAME                VARCHAR(127)        DEFAULT ''          COMMENT '用户名',
      MOBILE                  VARCHAR(31)         DEFAULT ''          COMMENT '用户手机号',
      NAME                    VARCHAR(127)        DEFAULT ''          COMMENT '名字',
      PASSWORD                VARCHAR(63)         DEFAULT ''          COMMENT '密码',
      SALT                    VARCHAR(31)         DEFAULT ''          COMMENT '加密参数',
      STATUS                  VARCHAR(31)         DEFAULT ''          COMMENT '账号状态 AccountStatus',
      VERSION                 INT                 DEFAULT 0           COMMENT '版本号',
      REMARK                  VARCHAR(1023)       DEFAULT ''          COMMENT '备注字段',
      STATE                   VARCHAR(31)                             COMMENT '数据状态 State' ,
      CREATED_ID              BIGINT                                  COMMENT '创建人' ,
      CREATED_TIME            DATETIME                                COMMENT '创建时间' ,
      UPDATED_ID              BIGINT                                  COMMENT '更新人' ,
      UPDATED_TIME            DATETIME                                COMMENT '更新时间' ,
      PRIMARY KEY (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT = '后台管理:管理员信息表';

-- account
-- USERNAME: admin
-- PASSWORD: admin@123456
-- INSERT INTO ADMIN_ACCOUNT(ID,USERNAME,MOBILE,NAME,PASSWORD,
--                           SALT,STATUS,STATE,CREATED_TIME,UPDATED_TIME)
-- VALUES (1, 'admin','18888888888','超级管理员','512478ae9b1ba6dd56e9afbe546f31b2','9X87CD','AccountStatus_C','State_C',NOW(),NOW());
--




-- ----------------------------
-- Table structure for ADMIN_ROLE
-- ----------------------------
DROP TABLE IF EXISTS ADMIN_ROLE;
CREATE TABLE ADMIN_ROLE(
                           ID                      BIGINT              NOT NULL            COMMENT '主键ID' ,
                           NAME                    VARCHAR(127)        DEFAULT ''          COMMENT '角色名字',
                           REMARK                  VARCHAR(1023)       DEFAULT ''          COMMENT '备注字段',
                           VERSION                 INT                 DEFAULT 0           COMMENT '版本号',
                           STATE                   VARCHAR(31)         DEFAULT ''          COMMENT '数据状态 State' ,
                           CREATED_ID              BIGINT                                  COMMENT '创建人' ,
                           CREATED_TIME            DATETIME                                COMMENT '创建时间' ,
                           UPDATED_ID              BIGINT                                  COMMENT '更新人' ,
                           UPDATED_TIME            DATETIME                                COMMENT '更新时间' ,
                           PRIMARY KEY (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci  COMMENT = '后台管理:管理员角色表';




-- ----------------------------
-- Table structure for ADMIN_AUTHORITY
-- ----------------------------
DROP TABLE IF EXISTS ADMIN_AUTHORITY;
CREATE TABLE ADMIN_AUTHORITY(
                                ID                      BIGINT              NOT NULL            COMMENT '主键ID' ,
                                NAME                    VARCHAR(127)        DEFAULT ''          COMMENT '权限名字',
                                DESCRIPTION             VARCHAR(1023)       DEFAULT ''          COMMENT '权限描述',
                                CATEGORY                VARCHAR(31)         DEFAULT ''         COMMENT '权限类型: 菜单组、菜单、按钮',
                                CODE                    VARCHAR(63)         DEFAULT ''          COMMENT '权限码',
                                ROUTE                   VARCHAR(255)        DEFAULT ''          COMMENT '路由',
                                LINK                    VARCHAR(1023)       DEFAULT ''          COMMENT '接口权限列表 jsonarray',
                                PARENT                  BIGINT                                  COMMENT '所属权限',
                                SORT                    INT                                     COMMENT '排序',
                                ICON                    VARCHAR(127)        DEFAULT ''          COMMENT '菜单图标',
                                VERSION                 INT                 DEFAULT 0           COMMENT '版本号',
                                REMARK                  VARCHAR(1023)       DEFAULT ''          COMMENT '备注字段',
                                STATE                   VARCHAR(31)         DEFAULT ''          COMMENT '数据状态 State' ,
                                CREATED_ID              BIGINT                                  COMMENT '创建人' ,
                                CREATED_TIME            DATETIME                                COMMENT '创建时间' ,
                                UPDATED_ID              BIGINT                                  COMMENT '更新人' ,
                                UPDATED_TIME            DATETIME                                COMMENT '更新时间' ,
                                PRIMARY KEY (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci  COMMENT = '后台管理:权限列表';

-- 系统设置
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (1,'系统管理','系统管理菜单组','AuthorityCategory_Folder','admin','/admin','',
        null,0,'fa fa-gear',0,'State_C',NOW(),NOW());
-- 账号管理
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (100,'账号管理','系统账号管理菜单','AuthorityCategory_Menu','admin_account','/admin/account','',
        1,0,'fa fa-user-circle',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10000,'账号-管理','系统账号管理菜单-管理','AuthorityCategory_Button','admin_account_query','','',
        100,0,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10001,'账号-添加','系统账号管理菜单-添加','AuthorityCategory_Button','admin_account_add','','',
        100,1,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10002,'账号-删除','系统账号管理菜单-删除','AuthorityCategory_Button','admin_account_remove','','',
        100,2,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10003,'账号-修改','系统账号管理菜单-修改','AuthorityCategory_Button','admin_account_update','','',
        100,3,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10004,'账号-禁用','系统账号管理菜单-禁用','AuthorityCategory_Button','admin_account_forbidden','','',
        100,4,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10005,'账号-解封','系统账号管理菜单-解封','AuthorityCategory_Button','admin_account_normalize','','',
        100,5,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10006,'账号-重置','系统账号管理菜单-重置密码','AuthorityCategory_Button','admin_account_reset','','',
        100,6,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10007,'账号-授权','系统账号管理菜单-角色配置','AuthorityCategory_Button','admin_account_role','','',
        100,7,'',0,'State_C',NOW(),NOW());
-- 角色管理
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (101,'角色管理','系统角色管理菜单','AuthorityCategory_Menu','admin_role','/admin/role','',
        1,1,'fa fa-vcard',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10100,'角色-管理','系统角色管理菜单-管理','AuthorityCategory_Button','admin_role_query','','',
        101,0,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10101,'角色-添加','系统角色管理菜单-添加','AuthorityCategory_Button','admin_role_add','','',
        101,1,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10102,'角色-删除','系统角色管理菜单-删除','AuthorityCategory_Button','admin_role_remove','','',
        101,2,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10103,'角色-修改','系统角色管理菜单-修改','AuthorityCategory_Button','admin_role_update','','',
        101,3,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10104,'角色-授权','系统角色管理菜单-配置菜单','AuthorityCategory_Button','admin_role_auth','','',
        101,4,'',0,'State_C',NOW(),NOW());

INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (102,'系统参数','系统参数相关分级','AuthorityCategory_Group','','','',
        1,2,'',0,'State_C',NOW(),NOW());
-- 系统参数
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (103,'系统参数','系统参数设置菜单','AuthorityCategory_Menu','admin_config','/admin/config','',
        1,3,'fa fa-certificate',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10300,'系统参数-管理','系统参数设置菜单-管理','AuthorityCategory_Button','admin_config_query','','',
        103,0,'',0,'State_C',NOW(),NOW());
INSERT INTO ADMIN_AUTHORITY (ID,NAME,DESCRIPTION,CATEGORY,CODE,ROUTE,LINK,
                             PARENT,SORT,ICON,VERSION,STATE,CREATED_TIME,UPDATED_TIME)
VALUES (10301,'系统参数-保存','系统参数设置菜单-保存','AuthorityCategory_Button','admin_config_update','','',
        103,1,'',0,'State_C',NOW(),NOW());


-- ----------------------------
-- Table structure for ADMIN_ROLE_AUTHORITY
-- ----------------------------
DROP TABLE IF EXISTS ADMIN_ROLE_AUTHORITY;
CREATE TABLE ADMIN_ROLE_AUTHORITY(
    ID                      BIGINT              NOT NULL            COMMENT '主键ID' ,
    ROLE_ID                 BIGINT                                  COMMENT '角色ID',
    AUTHORITY_ID            BIGINT                                  COMMENT '权限ID',
    VERSION                 INT                 DEFAULT 0           COMMENT '版本号',
    REMARK                  VARCHAR(1023)       DEFAULT ''          COMMENT '备注字段',
    STATE                   VARCHAR(31)         DEFAULT ''          COMMENT '数据状态 State' ,
    CREATED_ID              BIGINT                                  COMMENT '创建人' ,
    CREATED_TIME            DATETIME                                COMMENT '创建时间' ,
    UPDATED_ID              BIGINT                                  COMMENT '更新人' ,
    UPDATED_TIME            DATETIME                                COMMENT '更新时间' ,
    PRIMARY KEY (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT = '后台管理:角色-权限关系表';




-- ----------------------------
-- Table structure for ADMIN_ACCOUNT_ROLE
-- ----------------------------
DROP TABLE IF EXISTS ADMIN_ACCOUNT_ROLE;
CREATE TABLE ADMIN_ACCOUNT_ROLE(
    ID                      BIGINT              NOT NULL            COMMENT '主键ID' ,
    ACCOUNT_ID              BIGINT                                  COMMENT '账号ID',
    ROLE_ID                 BIGINT                                  COMMENT '角色ID',
    VERSION                 INT                 DEFAULT 0           COMMENT '版本号',
    REMARK                  VARCHAR(1023)       DEFAULT ''          COMMENT '备注字段',
    STATE                   VARCHAR(31)         DEFAULT ''          COMMENT '数据状态 Constant.State' ,
    CREATED_ID              BIGINT                                  COMMENT '创建人' ,
    CREATED_TIME            DATETIME                                COMMENT '创建时间' ,
    UPDATED_ID              BIGINT                                  COMMENT '更新人' ,
    UPDATED_TIME            DATETIME                                COMMENT '更新时间' ,
    PRIMARY KEY (ID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT = '后台管理:账号-角色关系表';






















