/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.service;

import cn.ipokerface.admin.AdminCacheService;
import cn.ipokerface.admin.entity.AdminAccountRole;
import cn.ipokerface.admin.entity.AdminRole;
import cn.ipokerface.admin.entity.AdminRoleAuthority;
import cn.ipokerface.admin.entity.AdminRoleUpdate;
import cn.ipokerface.admin.exception.RoleNotExistException;
import cn.ipokerface.admin.mapper.AdminAccountRoleMapper;
import cn.ipokerface.admin.mapper.AdminRoleAuthorityMapper;
import cn.ipokerface.admin.mapper.AdminRoleMapper;
import cn.ipokerface.admin.service.RoleService;
import cn.ipokerface.common.enums.State;
import cn.ipokerface.common.model.query.PaginationSortableSearchQueryModel;
import cn.ipokerface.common.utils.CollectionUtils;
import cn.ipokerface.snowflake.SnowflakeIdGenerator;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private AdminRoleMapper systemRoleMapper;
    @Autowired
    private AdminAccountRoleMapper systemAccountRoleMapper;
    @Autowired
    private AdminRoleAuthorityMapper systemRoleAuthorityMapper;
    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private SnowflakeIdGenerator snowflakeIdGenerator;

    @Override
    public List<AdminRole> pageRole(PaginationSortableSearchQueryModel query) {
        return this.systemRoleMapper.page(query);
    }

    @Override
    public long totalRole(PaginationSortableSearchQueryModel query) {
        return this.systemRoleMapper.total(query);
    }

    @Override
    public List<AdminRole> all() {
        return this.systemRoleMapper.selectAll();
    }

    @Override
    public Long addRole(AdminRole role) {
        role.initial();
        role.setId(this.snowflakeIdGenerator.nextId());
        this.systemRoleMapper.insertSelective((Object)role);
        return role.getId();
    }

    @Override
    public void updateRole(AdminRoleUpdate role) {
        AdminRole adminRole = (AdminRole)((Object)this.systemRoleMapper.selectByPrimaryKey(role.getId()));
        if (adminRole == null) {
            throw new RoleNotExistException();
        }
        this.systemRoleMapper.updateRole(role.getId(), role.getName(), role.getRemark(), adminRole.getVersion() + 1, LocalDateTime.now());
    }

    @Override
    public void remove(List<Long> roleIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(roleIds)) {
            return;
        }
        this.systemRoleMapper.delete(roleIds);
        this.systemAccountRoleMapper.deleteByAccountIds(roleIds);
    }

    @Override
    public void auth(List<Long> authIds, Long roleId) {
        ArrayList<Long> roleIds = new ArrayList<Long>();
        roleIds.add(roleId);
        this.systemRoleAuthorityMapper.deleteByRoleIds(roleIds);
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(authIds)) {
            ArrayList<AdminRoleAuthority> roleAuthorities = new ArrayList<AdminRoleAuthority>(authIds.size());
            for (Long authId : authIds) {
                AdminRoleAuthority roleAuthority = new AdminRoleAuthority();
                roleAuthority.setId(this.snowflakeIdGenerator.nextId());
                roleAuthority.initial();
                roleAuthority.setRoleId(roleId);
                roleAuthority.setAuthorityId(authId);
                roleAuthorities.add(roleAuthority);
            }
            int volume = 100;
            int count = roleAuthorities.size() / volume + (roleAuthorities.size() % volume > 0 ? 1 : 0);
            for (int i = 0; i < count; ++i) {
                int start = i * volume;
                int end = (i + 1) * volume;
                if (end > roleAuthorities.size()) {
                    end = roleAuthorities.size();
                }
                this.systemRoleAuthorityMapper.insertBatch(roleAuthorities.subList(start, end));
            }
        }
        this.adminCacheService.setRoleAuthorities(roleId, authIds);
    }

    @Override
    public List<AdminRole> accountRoles(Long accountId) {
        return this.systemAccountRoleMapper.selectByAccountId(accountId);
    }

    @Override
    public void accountRoleConfig(Long accountId, List<Long> roleIds) {
        this.systemAccountRoleMapper.deleteByAccountIds(CollectionUtils.asList((Object)accountId));
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(roleIds)) {
            ArrayList<AdminAccountRole> accountRoles = new ArrayList<AdminAccountRole>(roleIds.size());
            for (Long roleId : roleIds) {
                AdminAccountRole systemAccountRole = new AdminAccountRole();
                systemAccountRole.setId(this.snowflakeIdGenerator.nextId());
                systemAccountRole.setState(State.State_C);
                systemAccountRole.setVersion(0);
                systemAccountRole.setCreatedTime(LocalDateTime.now());
                systemAccountRole.setUpdatedTime(LocalDateTime.now());
                systemAccountRole.setAccountId(accountId);
                systemAccountRole.setRoleId(roleId);
                accountRoles.add(systemAccountRole);
            }
            int volume = 50;
            int count = accountRoles.size() / volume + (accountRoles.size() % volume > 0 ? 1 : 0);
            for (int i = 0; i < count; ++i) {
                int start = i * volume;
                int end = (i + 1) * volume;
                if (end > accountRoles.size()) {
                    end = accountRoles.size();
                }
                this.systemAccountRoleMapper.insertBatch(accountRoles.subList(start, end));
            }
        }
        this.adminCacheService.setAccountRoles(accountId, roleIds);
    }
}

