/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.service;

import cn.ipokerface.admin.AdminCacheService;
import cn.ipokerface.admin.entity.AdminAccount;
import cn.ipokerface.admin.enums.AccountStatus;
import cn.ipokerface.admin.exception.AccountForbiddenException;
import cn.ipokerface.admin.exception.AccountWrongException;
import cn.ipokerface.admin.exception.PasswordRequireException;
import cn.ipokerface.admin.exception.PasswordWrongException;
import cn.ipokerface.admin.mapper.AdminAccountMapper;
import cn.ipokerface.admin.service.AdminService;
import cn.ipokerface.common.utils.DigestUtils;
import cn.ipokerface.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminServiceImpl
implements AdminService {
    @Autowired
    private AdminAccountMapper adminAccountMapper;
    @Autowired
    private AdminCacheService adminCacheService;

    @Override
    public AdminAccount login(String username, String password, String ip) {
        AdminAccount adminAccount = this.adminAccountMapper.selectByUsername(username);
        if (adminAccount == null) {
            throw new AccountWrongException();
        }
        if (AccountStatus.AccountStatus_Forbidden.equals((Object)adminAccount.getStatus())) {
            throw new AccountForbiddenException();
        }
        if (!DigestUtils.md5Hex((String)(password + adminAccount.getSalt())).equals(adminAccount.getPassword())) {
            throw new PasswordWrongException();
        }
        return adminAccount;
    }

    @Override
    public void resetPassword(Long accountId, String password, String newPassword) {
        if (StringUtils.isEmpty((Object)password) || StringUtils.isEmpty((Object)newPassword)) {
            throw new PasswordRequireException();
        }
        AdminAccount systemAccount = (AdminAccount)((Object)this.adminAccountMapper.selectByPrimaryKey(accountId));
        if (systemAccount == null) {
            throw new AccountWrongException();
        }
        String md5password = DigestUtils.md5Hex((String)(password + systemAccount.getSalt()));
        if (!md5password.equals(systemAccount.getPassword())) {
            throw new PasswordWrongException();
        }
        this.adminAccountMapper.updatePassword(accountId, DigestUtils.md5Hex((String)(newPassword + systemAccount.getSalt())));
    }
}

