/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.service;

import cn.ipokerface.admin.ConfigurationCacheService;
import cn.ipokerface.admin.entity.Configuration;
import cn.ipokerface.admin.mapper.ConfigurationMapper;
import cn.ipokerface.admin.model.ConfigurationModel;
import cn.ipokerface.admin.service.ConfigurationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    @Autowired
    private ConfigurationMapper systemPropertyMapper;
    @Autowired
    private ConfigurationCacheService propertyCache;

    @Override
    public List<ConfigurationModel> properties() {
        return this.systemPropertyMapper.selectAll();
    }

    @Override
    @Transactional
    public void update(List<Configuration> adminProperties) {
        if (CollectionUtils.isEmpty(adminProperties)) {
            return;
        }
        int volume = 50;
        int count = adminProperties.size() / volume + (adminProperties.size() % volume > 0 ? 1 : 0);
        for (int i = 0; i < count; ++i) {
            int start = i * volume;
            int end = (i + 1) * volume;
            if (end > adminProperties.size()) {
                end = adminProperties.size();
            }
            this.systemPropertyMapper.updateBatch(adminProperties.subList(start, end));
        }
        this.flushDatabaseToRedis();
    }

    @Override
    public void flushDatabaseToRedis() {
        this.propertyCache.setProperties(this.properties());
    }
}

