package cn.ipokerface.admin.service;


import cn.ipokerface.admin.ConfigurationCacheService;
import cn.ipokerface.admin.entity.Configuration;
import cn.ipokerface.admin.mapper.ConfigurationMapper;
import cn.ipokerface.admin.model.ConfigurationModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class ConfigurationServiceImpl implements ConfigurationService {
    @Autowired
    private ConfigurationMapper systemPropertyMapper;
    @Autowired
    private ConfigurationCacheService propertyCache;


    @Override
    public List<ConfigurationModel> properties() {
        return systemPropertyMapper.selectAll();
    }


    @Override
    @Transactional
    public void update(List<Configuration> adminProperties) {
        if(CollectionUtils.isEmpty(adminProperties)) return;
        // 🈯️批量更新  一次50条
        int volume = 50;
        int count = adminProperties.size() / volume + (adminProperties.size() % volume > 0 ? 1:0);

        for(int i=0; i< count; i++)
        {
            int start = i * volume;
            int end = (i+1) * volume;
            if (end > adminProperties.size()) end = adminProperties.size();
            systemPropertyMapper.updateBatch(adminProperties.subList(start, end));
        }
        flushDatabaseToRedis();
    }


    @Override
    public void flushDatabaseToRedis() {
        propertyCache.setProperties(properties());
    }

}
