package cn.ipokerface.admin.service;

import cn.ipokerface.admin.entity.AdminAuthority;
import cn.ipokerface.admin.enums.AuthorityCategory;
import cn.ipokerface.admin.mapper.AdminAuthorityMapper;
import cn.ipokerface.admin.mapper.AdminRoleAuthorityMapper;
import cn.ipokerface.admin.model.AuthorityModel;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2020-05-29.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@Service
public class AuthorityServiceImpl implements AuthorityService {


    @Autowired
    private AdminRoleAuthorityMapper adminRoleAuthorityMapper;
    @Autowired
    private AdminAuthorityMapper adminAuthorityMapper;


    @Override
    public List<AuthorityModel> authorities(boolean skipGroup) {
        return adminAuthorityMapper.selectAll(skipGroup?AuthorityCategory.AuthorityCategory_Group:null);
    }
//
//
//
//    @Override
//    public List<AuthorityModel> authorityRole(Long roleId) {
//        return adminRoleAuthorityMapper.selectByRoleId(roleId);
//    }
//
//
//    @Override
//    public List<AuthorityTreeModel> buildAuthorityTree(List<AuthorityModel> authorities)
//    {
//        List<AuthorityTreeModel> models = new ArrayList<>();
//
//        if (CollectionUtils.isNotEmpty(authorities))
//        {
//            Map<Long, AuthorityTreeModel> parentMap = new HashMap<>(authorities.size());
//
//            // 第一遍 把所有model放到Map中
//            for(AuthorityModel authority: authorities)
//            {
//                AuthorityTreeModel model = new AuthorityTreeModel();
//                BeanUtils.copyProperties(authority, model);
//                parentMap.put(model.getId(), model);
//
//                if (model.getParent() == null || model.getParent().equals(0L)) models.add(model);
//            }
//
//            // 第二遍  根据map 构建父子关系
//            for(AuthorityTreeModel authority: parentMap.values())
//            {
//                if (authority.getParent() != null && !authority.getParent().equals(0L))
//                {
//                    AuthorityTreeModel parent = parentMap.get(authority.getParent());
//                    if (parent != null){
//                        parent.addChildren(authority);
//                    }
//                }
//            }
//        }
//
//        return models;
//    }
}
