package cn.ipokerface.admin.service;


import cn.ipokerface.admin.entity.AccountEntity;
import cn.ipokerface.admin.entity.AdminAccount;
import cn.ipokerface.admin.entity.AdminAccountUpdate;
import cn.ipokerface.admin.enums.AccountStatus;
import cn.ipokerface.admin.exception.AccountExistException;
import cn.ipokerface.admin.exception.AccountWrongException;
import cn.ipokerface.admin.mapper.AdminAccountMapper;
import cn.ipokerface.admin.mapper.AdminAccountRoleMapper;
import cn.ipokerface.admin.utils.PasswordUtil;
import cn.ipokerface.common.model.query.PaginationSortableSearchQueryModel;
import cn.ipokerface.common.utils.DigestUtils;
import cn.ipokerface.snowflake.SnowflakeIdGenerator;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-26.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@Service
public class AccountServiceImpl implements AccountService {

    @Autowired
    private AdminAccountMapper adminAccountMapper;
    @Autowired
    private AdminAccountRoleMapper adminAccountRoleMapper;


    @Autowired
    private SnowflakeIdGenerator snowflakeIdGenerator;


    @Override
    public List<AccountEntity> pageAccount(PaginationSortableSearchQueryModel pagination) {
        return adminAccountMapper.page(pagination);
    }

    @Override
    public long totalAccount(PaginationSortableSearchQueryModel pagination) {
        return adminAccountMapper.total(pagination);
    }

    @Override
    @Transactional
    public void add(AdminAccount account) {

        AdminAccount systemAccount = adminAccountMapper.selectByUsername(account.getUsername());
        if (systemAccount != null)
            throw new AccountExistException();
        account.initial();
        account.setId(snowflakeIdGenerator.nextId());
        account.setSalt(PasswordUtil.randomPasswd(6));
        account.setPassword(DigestUtils.md5Hex(account.getPassword()+ account.getSalt()));
        account.setStatus(AccountStatus.AccountStatus_Normal);
        adminAccountMapper.insertSelective(account);
    }

    @Override
    @Transactional
    public void delete(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) return;
        adminAccountMapper.delete(ids);
        // 删除账号角色
        adminAccountRoleMapper.deleteByAccountIds(ids);

    }


    @Override
    public void resetPassword(Long accountId, String newPassword) {

        AdminAccount adminAccount = adminAccountMapper.selectByPrimaryKey(accountId);
        if (adminAccount == null) throw new AccountWrongException();
        adminAccountMapper.updatePassword(accountId, DigestUtils.md5Hex(newPassword + adminAccount.getSalt()));

    }


    @Override
    public void toggleForbidden(Long accountId, AccountStatus status) {
        AdminAccount adminAccount = new AdminAccount();
        adminAccount.setId(accountId);
        adminAccount.setUpdatedTime(LocalDateTime.now());
        adminAccount.setStatus(status);
        adminAccountMapper.updateByPrimaryKeySelective(adminAccount);
    }

    @Override
    public void update(AdminAccountUpdate adminAccount) {

        AdminAccount account = adminAccountMapper.selectByPrimaryKey(adminAccount.getId());
        if (account == null) {
            throw new AccountWrongException();
        }
        adminAccountMapper.updateAccount(adminAccount.getId(),
                adminAccount.getName(),adminAccount.getMobile(),adminAccount.getRemark(),
                account.getVersion() + 1,
                LocalDateTime.now());
    }



}
