package cn.ipokerface.admin.service;

import cn.ipokerface.admin.entity.AccountEntity;
import cn.ipokerface.admin.entity.AdminAccount;
import cn.ipokerface.admin.entity.AdminAccountRoleEntity;
import cn.ipokerface.admin.entity.AdminAccountUpdate;
import cn.ipokerface.admin.enums.AccountStatus;
import cn.ipokerface.common.model.query.PaginationSortableSearchQueryModel;

import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-26.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public interface AccountService {


    /**
     *  分页数据列表
     *
     * @param pagination pagination
     * @return AccountModel
     */
    List<AccountEntity> pageAccount(PaginationSortableSearchQueryModel pagination);

    /**
     *
     *
     * @param pagination pagination
     * @return total
     */
    long totalAccount(PaginationSortableSearchQueryModel pagination);

    /**
     *  添加账号
     *
     * @param account account
     *
     */
    void add(AdminAccount account);

    /**
     *  重置账号的密码
     *
     * @param accountId accountId
     * @param newPassword newPassword
     */
    void resetPassword(Long accountId, String newPassword);

    /**
     *  切换账号的状态
     *
     * @param accountId accountId
     * @param status status
     */
    void toggleForbidden(Long accountId, AccountStatus status);

    /**
     *  删除一些账号
     *
     * @param ids ids
     */
    void delete(List<Long> ids);

    /**
     *  更新账号的数据
     *
     * @param account accountUpdateParam
     */
    void update(AdminAccountUpdate account);


}
