package cn.ipokerface.admin.mapper;

import cn.ipokerface.admin.entity.AdminRole;
import cn.ipokerface.admin.entity.AdminRoleEntity;
import cn.ipokerface.common.model.query.PaginationSortableSearchQueryModel;
import cn.ipokerface.mybatis.AbstractMapper;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.List;

public interface AdminRoleMapper extends AbstractMapper<Long, AdminRole> {

    /**
     *  分页数据
     *
     * @param param param
     * @return page data
     */
    List<AdminRole> page(PaginationSortableSearchQueryModel param);
    long total(PaginationSortableSearchQueryModel param);


    List<AdminRole> selectAll();



    int delete(List<Long> list);


    int updateRole(@Param("id")Long id,
                   @Param("name")String name,
                   @Param("remark")String remark,
                   @Param("version")int version,
                   @Param("updatedTime")LocalDateTime updatedTime);

}