package cn.ipokerface.admin.mapper;

import cn.ipokerface.admin.entity.AccountEntity;
import cn.ipokerface.admin.entity.AdminAccount;
import cn.ipokerface.common.model.query.PaginationSortableSearchQueryModel;
import cn.ipokerface.mybatis.AbstractMapper;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.List;

public interface AdminAccountMapper extends AbstractMapper<Long, AdminAccount> {


    /**
     * 通过username 获取 账号
     *
     * @param username  username
     * @return 账号
     */
    AdminAccount selectByUsername(@Param("username") String username);

    /**
     *  更新密码
     *
     * @param accountId accountId
     * @param password password
     * @return count
     */
    int updatePassword(@Param("accountId")Long accountId,
                       @Param("password") String password);


    /**
     *  更新角色
     *
     * @param id id
     * @param name name
     * @param mobile mobile
     * @param remark remark
     * @param updatedTime updatedTime
     * @return count
     */
    int updateAccount(@Param("id")Long id,
                      @Param("name")String name,
                      @Param("mobile")String mobile,
                      @Param("remark")String remark,
                      @Param("version")int version,
                      @Param("updatedTime")LocalDateTime updatedTime);


    /**
     *  分页数据
     *
     * @param param list
     * @return page data
     */
    List<AccountEntity> page(PaginationSortableSearchQueryModel param);
    long total(PaginationSortableSearchQueryModel param);

    /**
     *  批量删除
     *
     * @param list list
     * @return count
     */
    int delete(List<Long> list);

}