/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.spring.web;

import cn.ipokerface.admin.ResultCode;
import cn.ipokerface.admin.annontation.RequiredAuthorization;
import cn.ipokerface.admin.body.AccessModel;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.interceptor.AbstractInterceptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
public class AuthorityInterceptor
extends AbstractInterceptor {
    @Autowired
    private AdminCacheService adminCacheService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        RequiredAuthorization[] requireAuthorities = (RequiredAuthorization[])method.getAnnotationsByType(RequiredAuthorization.class);
        if (requireAuthorities != null && requireAuthorities.length > 0) {
            List<String> authorities = this.catchAuthorities(request);
            HashMap authoritiesMap = new HashMap();
            if (CollectionUtils.isNotEmpty(authorities)) {
                authorities.stream().forEach(code -> authoritiesMap.put(code, code));
            }
            for (RequiredAuthorization RequiredAuthorization2 : requireAuthorities) {
                String authority;
                String code2 = RequiredAuthorization2.code();
                if (StringUtils.isEmpty((Object)code2) || !StringUtils.isEmpty((Object)(authority = (String)authoritiesMap.get(code2)))) continue;
                this.responseJson(response, ResultCode.CODE_ADMIN_AUTHORIZATION);
                return false;
            }
        }
        return true;
    }

    private List<String> catchAuthorities(HttpServletRequest request) {
        AccessModel accessModel = (AccessModel)((Object)request.getAttribute("Access-Model"));
        List<String> authorityModels = this.adminCacheService.getRoleAuthorities(this.adminCacheService.getAccountRoles(accessModel.getAccountId()));
        return authorityModels;
    }
}

