/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.spring.web;

import cn.ipokerface.admin.ResultCode;
import cn.ipokerface.admin.body.AccessModel;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.admin.spring.web.InterceptorProperties;
import cn.ipokerface.web.interceptor.AbstractInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
public class AccessInterceptor
extends AbstractInterceptor {
    private static Logger logger = LoggerFactory.getLogger(AccessInterceptor.class);
    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private InterceptorProperties interceptorProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        AccessModel accessModel = (AccessModel)((Object)request.getAttribute("Access-Model"));
        if (accessModel == null) {
            this.responseJson(response, ResultCode.CODE_ADMIN_ACCESS_INVALID);
            return false;
        }
        if ("OCCUPIED".equals(accessModel.getAccessToken())) {
            this.responseJson(response, ResultCode.CODE_ADMIN_ACCESS_INVALID);
            return false;
        }
        long expiredTimestamp = this.interceptorProperties.getAccessExpiredTimestamp();
        if (System.currentTimeMillis() - accessModel.getAccessTimestamp() >= expiredTimestamp) {
            this.responseJson(response, ResultCode.CODE_ADMIN_ACCESS_EXPIRED);
            return false;
        }
        accessModel.setAccessTimestamp(System.currentTimeMillis());
        accessModel.setExpiredTimestamp(accessModel.getAccessTimestamp() + expiredTimestamp);
        this.adminCacheService.setAccess(accessModel);
        return true;
    }
}

