/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.controller;

import cn.ipokerface.admin.annontation.RequiredAuthorization;
import cn.ipokerface.admin.body.RoleModel;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.admin.entity.AdminRole;
import cn.ipokerface.admin.model.AdminRoleUpdate;
import cn.ipokerface.admin.param.RoleAddParam;
import cn.ipokerface.admin.param.RoleUpdateParam;
import cn.ipokerface.admin.service.RoleService;
import cn.ipokerface.common.model.BaseListModel;
import cn.ipokerface.common.model.BaseListTotalModel;
import cn.ipokerface.common.model.BaseModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.model.query.PaginationSortableSearchQueryModel;
import cn.ipokerface.common.utils.ListUtils;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.controller.BaseController;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/role"})
public class RoleController
extends BaseController {
    @Autowired
    private RoleService roleService;
    @Autowired
    private AdminCacheService adminCacheService;

    @RequiredAuthorization(code="admin_role")
    @RequestMapping(value={"/page"})
    public ResultBody page(PaginationSortableSearchQueryModel param) {
        List roles = this.roleService.pageRole(param);
        long total = this.roleService.totalRole(param);
        ArrayList roleModels = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)roles)) {
            roles.stream().forEach(role -> {
                RoleModel roleModel = new RoleModel();
                BeanUtils.copyProperties((Object)role, (Object)((Object)roleModel));
                roleModels.add(roleModel);
            });
        }
        return ResultBody.builder().data((BaseModel)new BaseListTotalModel(roleModels, total)).build();
    }

    @RequestMapping(value={"/all"})
    public ResultBody all() {
        List roles = this.roleService.all();
        ArrayList models = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)roles)) {
            roles.stream().forEach(item -> {
                RoleModel model = new RoleModel();
                BeanUtils.copyProperties((Object)item, (Object)((Object)model));
                models.add(model);
            });
        }
        return ResultBody.builder().data((BaseModel)new BaseListModel(models)).build();
    }

    @RequiredAuthorization(code="admin_role_add")
    @RequestMapping(value={"/add"})
    public ResultBody add(@Validated RoleAddParam param) {
        AdminRole adminRole = new AdminRole();
        BeanUtils.copyProperties((Object)((Object)param), (Object)adminRole);
        this.roleService.addRole(adminRole);
        return ResultBody.builder().build();
    }

    @RequiredAuthorization(code="admin_role_remove")
    @RequestMapping(value={"/delete"})
    public ResultBody delete(String roleIds) {
        if (!StringUtils.isEmpty((Object)roleIds)) {
            List ids = JSONArray.parseArray((String)roleIds, Long.class);
            this.roleService.remove(ids);
        }
        return ResultBody.builder().build();
    }

    @RequiredAuthorization(code="admin_role_update")
    @RequestMapping(value={"/update"})
    public ResultBody update(@Validated RoleUpdateParam param) {
        AdminRoleUpdate update = new AdminRoleUpdate();
        BeanUtils.copyProperties((Object)((Object)param), (Object)update);
        this.roleService.updateRole(update);
        return ResultBody.builder().build();
    }

    @RequiredAuthorization(code="admin_role_auth")
    @RequestMapping(value={"/auth"})
    public ResultBody auth(String auths, Long roleId) {
        List ids = null;
        if (!StringUtils.isEmpty((Object)auths)) {
            ids = JSONArray.parseArray((String)auths, String.class);
        }
        this.roleService.updateRoleAuthority(roleId, ids);
        this.adminCacheService.setRoleAuthorities(roleId, ids);
        return ResultBody.builder().build();
    }

    @RequiredAuthorization(code="admin_role_auth")
    @RequestMapping(value={"/authorities"})
    public ResultBody role(Long roleId) {
        List<String> models = this.adminCacheService.getRoleAuthorities(ListUtils.asList((Object)roleId));
        return ResultBody.builder().data((BaseModel)new BaseListModel(models)).build();
    }
}

