/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.controller;

import cn.ipokerface.admin.body.AccessModel;
import cn.ipokerface.admin.body.AccountModel;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.admin.entity.AdminAccount;
import cn.ipokerface.admin.exception.PasswordWrongException;
import cn.ipokerface.admin.param.LoginParam;
import cn.ipokerface.admin.service.AdminAccountService;
import cn.ipokerface.admin.spring.admin.AdminProperties;
import cn.ipokerface.admin.spring.web.InterceptorProperties;
import cn.ipokerface.common.model.BaseListModel;
import cn.ipokerface.common.model.BaseModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.DigestUtils;
import cn.ipokerface.web.controller.BaseController;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin"})
public class AdminController
extends BaseController {
    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private AdminProperties adminProperties;
    @Autowired
    private InterceptorProperties interceptorProperties;
    @Autowired
    private AdminAccountService adminAccountService;

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public ResultBody login(@Validated LoginParam param, HttpServletRequest request) {
        String ip = this.getClientIpAddress(request);
        AdminAccount adminAccount = null;
        if (this.adminProperties.getSuperAdminUsername().equals(param.getUsername())) {
            if (!param.getPassword().equals(DigestUtils.md5Hex((String)this.adminProperties.getSuperAdminPassword()))) {
                throw new PasswordWrongException();
            }
            adminAccount = new AdminAccount();
            adminAccount.setId(this.adminProperties.getSuperAdminId());
            adminAccount.setUsername(this.adminProperties.getSuperAdminUsername());
            adminAccount.setName(this.adminProperties.getSuperAdminName());
        } else {
            adminAccount = this.adminAccountService.login(param.getUsername(), param.getPassword());
        }
        AccountModel accountModel = new AccountModel();
        BeanUtils.copyProperties((Object)adminAccount, (Object)((Object)accountModel));
        AccessModel accessModel = new AccessModel();
        accessModel.setAccessToken(DigestUtils.md5Hex((String)(adminAccount.getUsername() + System.currentTimeMillis())));
        accessModel.setAccountId(adminAccount.getId());
        accessModel.setAccessTimestamp(System.currentTimeMillis());
        accessModel.setExpiredTimestamp(accessModel.getAccessTimestamp() + this.interceptorProperties.getAccessExpiredTimestamp());
        this.adminCacheService.setAccess(accessModel);
        this.adminCacheService.setAccount(accountModel);
        return ResultBody.builder().data((BaseModel)accessModel).build();
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.POST})
    public ResultBody logout(@RequestHeader(value="Access-Token") String token) {
        this.adminCacheService.removeAccess(token);
        return ResultBody.builder().build();
    }

    @RequestMapping(value={"/account"})
    public ResultBody account(@RequestHeader(value="Access-Token") String token) throws Exception {
        return ResultBody.builder().data((BaseModel)this.adminCacheService.getAccount(token)).build();
    }

    @RequestMapping(value={"/authorities"})
    public ResultBody authorities(@RequestAttribute(value="Access-Model") AccessModel accessModel) throws Exception {
        List<String> authorityModelList = this.adminCacheService.getRoleAuthorities(this.adminCacheService.getAccountRoles(accessModel.getAccountId()));
        return ResultBody.builder().data((BaseModel)new BaseListModel(authorityModelList)).build();
    }

    @RequestMapping(value={"/password"}, method={RequestMethod.POST})
    public ResultBody password(@RequestAttribute(value="Access-Model") AccessModel accessModel, String password, String newPassword) throws Exception {
        this.adminAccountService.resetPassword(accessModel.getAccountId(), password, newPassword);
        return ResultBody.builder().build();
    }
}

