/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.cache;

import cn.ipokerface.admin.body.AccessModel;
import cn.ipokerface.admin.body.AccountModel;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.admin.spring.admin.AdminCacheProperties;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.redis.JedisClient;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminCacheServiceRedis
implements AdminCacheService {
    public static final String KEY_ADMIN_ACCOUNT_ID_MODEL_MAP = ":ACCOUNT_ID_MODEL_MAP";
    public static final String KEY_ADMIN_TOKEN_ACCESS_MAP = ":TOKEN_ACCESS_MAP";
    public static final String KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP = ":ACCOUNT_ID_ACCESS_MAP";
    public static final String KEY_ADMIN_AUTHORITY_ID_MAP = ":AUTHORITY_ID_MAP";
    public static final String KEY_ADMIN_ROLE_AUTHORITY_MAP = ":ROLE_AUTHORITY_MAP";
    public static final String KEY_ADMIN_ACCOUNT_ROLE_MAP = ":ADMIN_ACCOUNT_ROLE_MAP";
    @Autowired
    private JedisClient jedisClient;
    @Autowired
    private AdminCacheProperties adminCacheProperties;

    @Override
    public void setAccount(AccountModel account) {
        if (account == null || account.getId() == null) {
            return;
        }
        this.jedisClient.hset(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_ACCOUNT_ID_MODEL_MAP, account.getId().toString(), account.toJsonString());
    }

    @Override
    public AccountModel getAccount(Long accountId) {
        if (accountId == null) {
            return null;
        }
        String result = this.jedisClient.hget(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_ACCOUNT_ID_MODEL_MAP, accountId.toString());
        return StringUtils.isEmpty((Object)result) ? null : (AccountModel)((Object)JSON.parseObject((String)result, AccountModel.class));
    }

    @Override
    public AccountModel getAccount(String accessToken) {
        AccessModel accessModel = this.getAccess(accessToken);
        if (accessModel == null) {
            return null;
        }
        return this.getAccount(accessModel.getAccountId());
    }

    @Override
    public void setAccess(AccessModel accessModel) {
        AccessModel oldAccess;
        String result = this.jedisClient.hget(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accessModel.getAccountId().toString());
        if (!StringUtils.isEmpty((Object)result) && (oldAccess = (AccessModel)((Object)JSON.parseObject((String)result, AccessModel.class))) != null && !oldAccess.getAccessToken().equals(accessModel.getAccessToken())) {
            String accessToken = oldAccess.getAccessToken();
            oldAccess.setAccessToken("OCCUPIED");
            oldAccess.setAccountId(ACCESS_OCCUPIED_ID);
            this.jedisClient.hset(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_TOKEN_ACCESS_MAP, accessToken, oldAccess.toJsonString());
        }
        this.jedisClient.hset(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_TOKEN_ACCESS_MAP, accessModel.getAccessToken(), accessModel.toJsonString());
        this.jedisClient.hset(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accessModel.getAccountId().toString(), accessModel.toJsonString());
    }

    @Override
    public void removeAccess(String accessToken) {
        this.jedisClient.hdel(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_TOKEN_ACCESS_MAP, new String[]{accessToken});
    }

    @Override
    public AccessModel getAccess(String accessToken) {
        String result = this.jedisClient.hget(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_TOKEN_ACCESS_MAP, accessToken);
        return StringUtils.isEmpty((Object)result) ? null : (AccessModel)((Object)JSON.parseObject((String)result, AccessModel.class));
    }

    @Override
    public AccessModel getAccess(Long accountId) {
        if (accountId == null) {
            return null;
        }
        String result = this.jedisClient.hget(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_ACCOUNT_ID_ACCESS_MAP, accountId.toString());
        return StringUtils.isEmpty((Object)result) ? null : (AccessModel)((Object)JSON.parseObject((String)result, AccessModel.class));
    }

    @Override
    public void setRoleAuthorities(Long roleId, List<String> authorityIds) {
        if (roleId == null) {
            return;
        }
        if (authorityIds == null) {
            authorityIds = new ArrayList<String>();
        }
        this.jedisClient.hset(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_ROLE_AUTHORITY_MAP, roleId.toString(), JSON.toJSONString(authorityIds));
    }

    @Override
    public void setAccountRoles(Long accountId, List<Long> roleIds) {
        if (accountId == null) {
            return;
        }
        if (roleIds == null) {
            roleIds = new ArrayList<Long>();
        }
        this.jedisClient.hset(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_ACCOUNT_ROLE_MAP, accountId.toString(), JSON.toJSONString(roleIds));
    }

    @Override
    public List<Long> getAccountRoles(Long accountId) {
        String roleString = this.jedisClient.hget(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_ACCOUNT_ROLE_MAP, accountId.toString());
        return StringUtils.isEmpty((Object)roleString) ? null : JSON.parseArray((String)roleString, Long.class);
    }

    @Override
    public List<String> getRoleAuthorities(List<Long> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return null;
        }
        HashSet set = new HashSet();
        String[] arr = new String[roleIds.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = String.valueOf(roleIds.get(i));
        }
        List result = this.jedisClient.hmget(this.adminCacheProperties.getKeyPrefix() + KEY_ADMIN_ROLE_AUTHORITY_MAP, arr);
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            result.stream().forEach(item -> {
                List list = JSON.parseArray((String)item, String.class);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    set.addAll(list);
                }
            });
        }
        return new ArrayList<String>(set);
    }
}

