/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.admin.authority;

import cn.ipokerface.admin.authority.AuthorityRepository;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.admin.spring.admin.AdminProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthorityInitializingBean
implements InitializingBean {
    @Autowired
    private AuthorityRepository authorityRepository;
    @Autowired
    private AdminCacheService adminCacheService;
    @Autowired
    private AdminProperties adminProperties;

    public void afterPropertiesSet() throws Exception {
        List<String> authorities = this.authorityRepository.authorities();
        if (CollectionUtils.isEmpty(authorities)) {
            authorities = new ArrayList<String>();
        }
        authorities.add("admin");
        authorities.add("admin_account");
        authorities.add("admin_account_query");
        authorities.add("admin_account_add");
        authorities.add("admin_account_remove");
        authorities.add("admin_account_forbidden");
        authorities.add("admin_account_normalize");
        authorities.add("admin_account_reset");
        authorities.add("admin_account_update");
        authorities.add("admin_account_role");
        authorities.add("admin_role");
        authorities.add("admin_role_query");
        authorities.add("admin_role_add");
        authorities.add("admin_role_remove");
        authorities.add("admin_role_update");
        authorities.add("admin_role_auth");
        authorities.add("admin_config");
        authorities.add("admin_config_query");
        authorities.add("admin_config_update");
        this.adminCacheService.setRoleAuthorities(this.adminProperties.getSuperAdminRoleId(), authorities);
        this.adminCacheService.setAccountRoles(this.adminProperties.getSuperAdminId(), Arrays.asList(this.adminProperties.getSuperAdminRoleId()));
    }
}

