package cn.ipokerface.admin.spring.web;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * Created by       mac
 * Create Date      2020/12/13
 * Version          1.0.0
 * Description:
 */


@Configuration
@AutoConfigureAfter({AccessInterceptor.class,AuthorityInterceptor.class})
@EnableConfigurationProperties({InterceptorProperties.class})
public class SpringWebAutoConfiguration implements WebMvcConfigurer {


    @Autowired
    private AccessInterceptor accessInterceptor;
    @Autowired
    private AccessAttributeInterceptor accessAttributeInterceptor;
    @Autowired
    private AuthorityInterceptor authorityInterceptor;
    @Autowired
    private InterceptorProperties interceptorProperties;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration accessRegistration = registry.addInterceptor(accessAttributeInterceptor)
                .addPathPatterns("/api/**");



        // access
        InterceptorRegistration interceptorRegistration = registry
                .addInterceptor(accessInterceptor)
                .addPathPatterns("/api/admin/**")
                .excludePathPatterns("/api/admin/login");
        if (!CollectionUtils.isEmpty(interceptorProperties.getIncludeAccessPaths())) {
            interceptorRegistration.addPathPatterns(interceptorProperties.getIncludeAccessPaths());
        }
        if (!CollectionUtils.isEmpty(interceptorProperties.getExcludeAccessPaths())) {
            interceptorRegistration.excludePathPatterns(interceptorProperties.getExcludeAccessPaths());
        }


        // authority
        InterceptorRegistration authorityRegistration = registry.addInterceptor(authorityInterceptor)
                .addPathPatterns("/api/admin/**")
                .excludePathPatterns("/api/admin/login");
        if (!CollectionUtils.isEmpty(interceptorProperties.getIncludeAuthorityPaths())) {
            authorityRegistration.addPathPatterns(interceptorProperties.getIncludeAuthorityPaths());
        }
        if (!CollectionUtils.isEmpty(interceptorProperties.getExcludeAuthorityPaths())) {
            authorityRegistration.excludePathPatterns(interceptorProperties.getExcludeAuthorityPaths());
        }
        if (!CollectionUtils.isEmpty(interceptorProperties.getExcludeAccessPaths())) {
            authorityRegistration.excludePathPatterns(interceptorProperties.getExcludeAccessPaths());
        }
    }
}
