package cn.ipokerface.admin.spring.web;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2020-05-25.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
@Component
@ConfigurationProperties(prefix = "spring.admin.interceptor")
public class InterceptorProperties {

    // no need access
    private List<String> excludeAccessPaths;

    // need access
    private List<String> includeAccessPaths;

    // need authority
    private List<String> includeAuthorityPaths;

    // no need authority
    private List<String> excludeAuthorityPaths;


    private long accessExpiredTimestamp = 1800000L;


    public List<String> getExcludeAccessPaths() {
        return excludeAccessPaths;
    }

    public void setExcludeAccessPaths(List<String> excludeAccessPaths) {
        this.excludeAccessPaths = excludeAccessPaths;
    }

    public List<String> getIncludeAccessPaths() {
        return includeAccessPaths;
    }

    public void setIncludeAccessPaths(List<String> includeAccessPaths) {
        this.includeAccessPaths = includeAccessPaths;
    }

    public List<String> getIncludeAuthorityPaths() {
        return includeAuthorityPaths;
    }

    public void setIncludeAuthorityPaths(List<String> includeAuthorityPaths) {
        this.includeAuthorityPaths = includeAuthorityPaths;
    }

    public List<String> getExcludeAuthorityPaths() {
        return excludeAuthorityPaths;
    }

    public void setExcludeAuthorityPaths(List<String> excludeAuthorityPaths) {
        this.excludeAuthorityPaths = excludeAuthorityPaths;
    }

    public long getAccessExpiredTimestamp() {
        return accessExpiredTimestamp;
    }

    public void setAccessExpiredTimestamp(long accessExpiredTimestamp) {
        this.accessExpiredTimestamp = accessExpiredTimestamp;
    }
}
