package cn.ipokerface.admin.spring.web;


import cn.ipokerface.admin.Constant;
import cn.ipokerface.admin.ResultCode;
import cn.ipokerface.admin.annontation.RequiredAuthorization;
import cn.ipokerface.admin.body.AccessModel;
import cn.ipokerface.admin.cache.AdminCacheService;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.interceptor.AbstractInterceptor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2020-06-01.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@Component
public class AuthorityInterceptor extends AbstractInterceptor {


    @Autowired
    private AdminCacheService adminCacheService;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {


        // 如果不是controller 资源  则直接返回
        if (!(handler instanceof HandlerMethod)) return true;

        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();

        RequiredAuthorization[] requireAuthorities = method.getAnnotationsByType(RequiredAuthorization.class);
        if (requireAuthorities != null && requireAuthorities.length > 0) {
            // 需要验证权限
            List<String> authorities = catchAuthorities(request);
            Map<String,String> authoritiesMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(authorities)) {
                authorities.stream().forEach((code)->{
                    authoritiesMap.put(code, code);
                });
            }
            for(RequiredAuthorization RequiredAuthorization: requireAuthorities) {
                String code = RequiredAuthorization.code();
                if (StringUtils.isEmpty(code)) continue;
                String authority = authoritiesMap.get(code);
                if (StringUtils.isEmpty(authority)) {
                    responseJson(response, ResultCode.CODE_ADMIN_AUTHORIZATION);
                    return false;
                }
            }
        }

        return true;
    }


    private List<String> catchAuthorities(HttpServletRequest request) {
        AccessModel accessModel = (AccessModel) request.getAttribute(Constant.REQUEST_ATTRIBUTE_ACCESS);
        List<String> authorityModels = adminCacheService.getRoleAuthorities(adminCacheService.getAccountRoles(accessModel.getAccountId()));
        return authorityModels;
    }



}
